package commandTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import simulation.Memory;

import commands.NumberCommand;
import commands.ReadCommand;

public class ReadCommandTest extends TestCase {

	private ReadCommand readCommand = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		readCommand = new ReadCommand();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("READ", readCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("ReadMemory", readCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, readCommand.getParameterCount());
	}

	public void testDoCommand() {
		Memory memory = new Memory();
		int size = 10;
		memory.setSize(size);
		for (int i=0; i<size; i++) {
			memory.setValue(i, size-i);
		}
		readCommand.setMemory(memory);
		NumberCommand nc = new NumberCommand();
		nc.setNumber(3000);
		readCommand.addParameter(nc);
		assertEquals(7, readCommand.doCommand());
		nc.setNumber(14000);
		assertEquals(6, readCommand.doCommand());
	}

	public void testIsThisCommand() {
		assertTrue(readCommand.isThisCommand("READ") != null);
		assertTrue(readCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		readCommand.addParameter(nc1);
		assertEquals("READ 123456",readCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("ReadCommand");
		suite.addTestSuite(ReadCommandTest.class);
		return suite;
	}
}
