package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SinCommand;

public class SinCommandTest extends TestCase {

	private SinCommand sinCommand = null;
	private AICommand aiCommand = null;
	
	public SinCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		sinCommand = new SinCommand();
		aiCommand = sinCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("SIN", sinCommand.getShortName());
		assertEquals("SIN", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Sinus", sinCommand.getLongName());
		assertEquals("Sinus", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, sinCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,sinCommand.getCurrentParameterCount());
		sinCommand.addParameter(mock1);
		sinCommand.addParameter(mock2);
		assertEquals(1,sinCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		sinCommand.addParameter(nc1);
		assertEquals(-803,sinCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(1,sinCommand.getCurrentParameterCount());
		assertEquals(0,sinCommand.doCommand());
		nc1.setNumber(1570);
		assertEquals(999,sinCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(sinCommand.isThisCommand("SIN") != null);
		assertTrue(sinCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		sinCommand.addParameter(nc1);
		assertEquals("SIN 123456",sinCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("SinCommand");
		suite.addTestSuite(SinCommandTest.class);
		return suite;
	}
}
