package commandTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.NumberCommand;
import commands.SleepCommand;

public class SleepCommandTest extends TestCase {

	private SleepCommand sleepCommand = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		sleepCommand = new SleepCommand();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("SLEEP", sleepCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Sleep", sleepCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, sleepCommand.getParameterCount());
	}

	public void testIsThisCommand() {
		assertTrue(sleepCommand.isThisCommand("SLEEP") != null);
		assertTrue(sleepCommand.isThisCommand("FALSCH") == null);
	}

	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		sleepCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		sleepCommand.addParameter(nc2);
		assertEquals(2,sleepCommand.getCurrentParameterCount());
		assertEquals(654321,sleepCommand.doCommand(false));
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		sleepCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		sleepCommand.addParameter(nc2);
		assertEquals("SLEEP 123456 654321",sleepCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("SleepCommand");
		suite.addTestSuite(SleepCommandTest.class);
		return suite;
	}
}
