package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SqrCommand;

public class SqrCommandTest extends TestCase {

	private SqrCommand sqrCommand = null;
	private AICommand aiCommand = null;
	
	public SqrCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		sqrCommand = new SqrCommand();
		aiCommand = sqrCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("SQR", sqrCommand.getShortName());
		assertEquals("SQR", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("SquareRoot", sqrCommand.getLongName());
		assertEquals("SquareRoot", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, sqrCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,sqrCommand.getCurrentParameterCount());
		sqrCommand.addParameter(mock1);
		assertEquals(1,sqrCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		sqrCommand.addParameter(nc1);
		assertEquals(1,sqrCommand.getCurrentParameterCount());
		assertEquals(11111,sqrCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(0,sqrCommand.doCommand());
		nc1.setNumber(-654321);
		assertEquals(0,sqrCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(sqrCommand.isThisCommand("SQR") != null);
		assertTrue(sqrCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		sqrCommand.addParameter(nc1);
		assertEquals("SQR 123456", sqrCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("SqrCommand");
		suite.addTestSuite(SqrCommandTest.class);
		return suite;
	}
}
