package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SubCommand;

public class SubCommandTest extends TestCase {

	private SubCommand subCommand = null;
	private AICommand aiCommand = null;
	
	public SubCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		subCommand = new SubCommand();
		aiCommand = subCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("SUB", subCommand.getShortName());
		assertEquals("SUB", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("-", subCommand.getLongName());
		assertEquals("-", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, subCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,subCommand.getCurrentParameterCount());
		subCommand.addParameter(mock1);
		subCommand.addParameter(mock2);
		assertEquals(2,subCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		subCommand.addParameter(nc1);
		try {
			assertEquals(123456,subCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		subCommand.addParameter(nc2);
		assertEquals(2,subCommand.getCurrentParameterCount());
		assertEquals(-530865,subCommand.doCommand());
		//IAICommand mock1 = createStrictMock(IAICommand.class);
		//expect(mock1.doCommand()).andReturn(123456);
		//expect(mock1.doCommand()).andReturn(123456);
		//expect(mock1.doCommand()).andReturn(654321);
		//replay();
		//addCommand.addParameter(mock1);
		//addCommand.addParameter(mock1);
		//assertEquals(2,addCommand.getCurrentParameterCount());
		//assertEquals(777777,addCommand.doCommand());
		//verify(mock1);
	}
	
	public void testIsThisCommand() {
		assertTrue(subCommand.isThisCommand("SUB") != null);
		assertTrue(subCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		subCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		subCommand.addParameter(nc2);
		assertEquals("SUB 123456 654321",subCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("SubCommand");
		suite.addTestSuite(SubCommandTest.class);
		return suite;
	}
}
