package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SumCommand;

public class SumCommandTest extends TestCase {

	private SumCommand sumCommand = null;
	private AICommand aiCommand = null;
	
	public SumCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		sumCommand = new SumCommand();
		aiCommand = sumCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("SUM", sumCommand.getShortName());
		assertEquals("SUM", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Sum", sumCommand.getLongName());
		assertEquals("Sum", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, sumCommand.getParameterCount());
		assertEquals(2, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,sumCommand.getCurrentParameterCount());
		sumCommand.addParameter(mock1);
		sumCommand.addParameter(mock2);
		assertEquals(2,sumCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(12345);
		sumCommand.addParameter(nc1);
		try {
			assertEquals(0,sumCommand.doCommand());
		} catch (Exception e) {
			fail("Missing Parameter should not result in a Exception: " + e.getMessage());
		}
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		sumCommand.addParameter(nc2);
		assertEquals(2,sumCommand.getCurrentParameterCount());
		assertEquals(7851852,sumCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(sumCommand.isThisCommand("SUM") != null);
		assertTrue(sumCommand.isThisCommand("FALSCH") == null);
	}
	
	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		sumCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		sumCommand.addParameter(nc2);
		assertEquals("SUM 123456 654321",sumCommand.getString());
	}
	
	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("SumCommand");
		suite.addTestSuite(SumCommandTest.class);
		return suite;
	}
}
