package commandTests;

import static org.easymock.EasyMock.createStrictMock;
import static org.easymock.EasyMock.replay;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.TanCommand;

public class TanCommandTest extends TestCase {

	private TanCommand tanCommand = null;
	private AICommand aiCommand = null;
	
	public TanCommandTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		super.setUp();
		tanCommand = new TanCommand();
		aiCommand = tanCommand;
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("TAN", tanCommand.getShortName());
		assertEquals("TAN", aiCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("Tangens", tanCommand.getLongName());
		assertEquals("Tangens", aiCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(1, tanCommand.getParameterCount());
		assertEquals(1, aiCommand.getParameterCount());
	}

	public void testAddParameter() {
		IAICommand mock1 = createStrictMock(IAICommand.class);
		IAICommand mock2 = createStrictMock(IAICommand.class);
		replay();
		assertEquals(0,tanCommand.getCurrentParameterCount());
		tanCommand.addParameter(mock1);
		tanCommand.addParameter(mock2);
		assertEquals(1,tanCommand.getCurrentParameterCount());
	}
	
	public void testDoCommand() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		tanCommand.addParameter(nc1);
		assertEquals(1351,tanCommand.doCommand());
		nc1.setNumber(0);
		assertEquals(1,tanCommand.getCurrentParameterCount());
		assertEquals(0,tanCommand.doCommand());
		nc1.setNumber(-1570);
		assertEquals(-1255765,tanCommand.doCommand());
	}
	
	public void testIsThisCommand() {
		assertTrue(tanCommand.isThisCommand("TAN") != null);
		assertTrue(tanCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		tanCommand.addParameter(nc1);
		assertEquals("TAN 123456",tanCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("TanCommand");
		suite.addTestSuite(TanCommandTest.class);
		return suite;
	}
}
