package commandTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import simulation.Memory;

import commands.NumberCommand;
import commands.WriteCommand;

public class WriteCommandTest extends TestCase {

	private WriteCommand writeCommand = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		writeCommand = new WriteCommand();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetShortName() {
		assertEquals("WRITE", writeCommand.getShortName());
	}

	public void testGetLongName() {
		assertEquals("WriteMemory", writeCommand.getLongName());
	}

	public void testGetParameterCount() {
		assertEquals(2, writeCommand.getParameterCount());
	}

	public void testDoCommand() {
		Memory memory = new Memory();
		int size = 10;
		int value1 = 3;
		int value2 = 6000;
		memory.setSize(size);
		writeCommand.setMemory(memory);
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(value1 * 1000);
		writeCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(value2);
		writeCommand.addParameter(nc2);
		assertEquals(value2, writeCommand.doCommand());
		assertEquals(value2,memory.getValue(value1));
	}

	public void testIsThisCommand() {
		assertTrue(writeCommand.isThisCommand("WRITE") != null);
		assertTrue(writeCommand.isThisCommand("FALSCH") == null);
	}

	public void testGetString() {
		NumberCommand nc1 = new NumberCommand();
		nc1.setNumber(123456);
		writeCommand.addParameter(nc1);
		NumberCommand nc2 = new NumberCommand();
		nc2.setNumber(654321);
		writeCommand.addParameter(nc2);
		assertEquals("WRITE 123456 654321",writeCommand.getString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("WriteCommand");
		suite.addTestSuite(WriteCommandTest.class);
		return suite;
	}
}
