package commands;

import global.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class AICommand implements IAICommand {
	
	public enum IsExecutedType {
		NEVER, MAYBE, ALWAYS
	}
	
	private List<IAICommand> parameters = null;
	
	private Logger logger = null;
	
	protected boolean stop = false;
	
	public abstract String getShortName();
	
	public abstract String getLongName();
		
	public abstract int getParameterCount();
	
	public abstract IAICommand isThisCommand(String string);
	
	public abstract int doCommand();
	
	public abstract int doCommand(boolean withSideEffects);
	
	public abstract boolean isConstant();
	
	public abstract boolean hasSideEffects(boolean inclusiveParameter);
	
	public abstract IsExecutedType isParameterExecuted(int paramID);
	
	public abstract IAICommand copy();
	
	public abstract IAICommand copyRandom();
	
	public AICommand() {
		parameters = new ArrayList<IAICommand>();
	}
	
	public AICommand(AICommand src) {
		parameters = new ArrayList<IAICommand>();
		setLogger(src.getLogger());
		for (int i=0; i<src.getCurrentParameterCount(); i++) {
			IAICommand param = ((AICommand)src.getParameter(i)).copy();
			this.addParameter(param);
		}
	}
	
	public void addParameter(IAICommand cmd) {
		if (parameters != null) {
			if (parameters.size() < getParameterCount()) {
				parameters.add(cmd);
			}
		}
	}
	
	public int getCurrentParameterCount() {
		if (parameters == null) {
			return 0;
		} else {
			return parameters.size();
		}
	}
	
	public IAICommand getParameter(int i) {
		if ((i>=0) && (i<getCurrentParameterCount())) {	
			return parameters.get(i);
		}
		return null;
	}
	
	public void setParameter(int i, AICommand command) {
		// TODO: Test missing
		if ((i>=0) && (i<getCurrentParameterCount())) {	
			parameters.set(i, command);
		}
	}
	
	public int getProgramDepth() {
		// TODO: Test missing
		int ret = 0;
		for (int i=0; i<getCurrentParameterCount(); i++) {
			int tmp = ((AICommand)getParameter(i)).getProgramDepth();
			if (tmp > ret) {
				ret = tmp;
			}
		}
		return ret + 1;
	}

	public void clearParameter() {
		parameters.clear();
	}
	
	public void setLogger(Logger newLogger) {
		logger = newLogger;
	}
	
	public Logger getLogger() {
		return logger;
	}
	
	public void logError(String method, String text) {
		if (logger != null) {
			logger.LogError(method, text);
		}
	}
	
	public void logExecute(String method, String text) {
		if (logger != null) {
			logger.LogExecute(method, text);
		}
	}
	
	public String getString() {
		String ret = getShortName();
		for (int i=0; i<getCurrentParameterCount(); i++) {
			ret = ret + " " + ((AICommand)getParameter(i)).getString();
		}
		return ret;
	}
	
	public void setRandomValue(Random random) {
	}
	
	public void stopExec() {
		this.stop = true;
		for (int i=getCurrentParameterCount()-1; i>=0; i--) {
			((AICommand)getParameter(i)).stopExec();
		}
	}

	public void resetStopExec() {
		this.stop = false;
		for (int i=0; i<getCurrentParameterCount(); i++) {
			((AICommand)getParameter(i)).resetStopExec();
		}
	}
	
	public boolean isTrue(int value) {
		if (value > 0) {
			return true;
		} else {
			return false;
		}
	}
}
