package commands;



public class CosCommand extends AICommand {
	
	@Override
	public String getShortName() {
		return "COS";
	}
	
	@Override
	public String getLongName() {
		return "Cosinus";
	}
	
	@Override
	public int getParameterCount() {
		return 1;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			ret = getParameter(0).doCommand(withSideEffects);
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing first parameter");
		}
		double a = ((double) ret) / 1000;
		ret = (int) (Math.cos(a) * 1000);
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	public CosCommand() {
		super();
	}

	public CosCommand(CosCommand src) {
		super(src);
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new CosCommand(this);
		}
		return null;
	}

	@Override
	public IAICommand copy() {
		return new CosCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// all parameters must be const to be const
		boolean ret = true;
		for (int i=0; i<this.getCurrentParameterCount(); i++) {
			ret = ret && ((AICommand)this.getParameter(i)).isConstant();
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		boolean ret = false;
		if (inclusiveParameter) {
			for (int i=0; i<this.getCurrentParameterCount(); i++) {
				ret = ret || ((AICommand)this.getParameter(i)).hasSideEffects(inclusiveParameter);
			}
		}
		return ret;
	}
}
