package commands;

import simulation.SimulationDisplay;

public class DisplayCommand extends AICommand implements IAICommand {

	private SimulationDisplay display = null;
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			int pos = (int)(getParameter(0).doCommand(withSideEffects) / 1000);
			if (!stop) {
				if (display != null) {
					ret = display.getValue(Math.abs(pos));
				} else {
					logError(this.getClass().getName() + ".doCommand()","Display not found");
				}
			}
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public String getLongName() {
		return "ReadDisplay";
	}

	@Override
	public int getParameterCount() {
		return 1;
	}

	@Override
	public String getShortName() {
		return "DISP";
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new DisplayCommand(this);
		}
		return null;
	}

	public void setDisplay(SimulationDisplay newDisplay) {
		display = newDisplay;
	}
	
	public SimulationDisplay getDisplay() {
		return display;
	}
	
	public DisplayCommand() {
		super();
	}
	
	public DisplayCommand(DisplayCommand src) {
		super(src);
		setDisplay(src.getDisplay());
	}

	@Override
	public IAICommand copy() {
		return new DisplayCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// always say is const even some values are const
		return false;
	}

	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		return true;
	}
}
