package commands;



public class EquCommand extends AICommand {
	
	@Override
	public String getShortName() {
		return "EQU";
	}
	
	@Override
	public String getLongName() {
		return "Equal";
	}
	
	@Override
	public int getParameterCount() {
		return 2;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int param1 = 0;
		int param2 = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			param1 = getParameter(0).doCommand(withSideEffects);
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing first parameter");
		}
		if (stop) {
			return 0;
		}
		logExecute(this.getClass().getName() + ".doCommand()", ",");
		if (getParameter(1) != null) {
			param2 = getParameter(1).doCommand(withSideEffects);
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing second parameter");
		}
		int ret = (param1 == param2 ? 1000 : -1000); 
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	public EquCommand() {
		super();
	}

	public EquCommand(EquCommand src) {
		super(src);
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new EquCommand(this);
		}
		return null;
	}

	@Override
	public IAICommand copy() {
		return new EquCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// all parameters must be const to be const
		boolean ret = true;
		for (int i=0; i<this.getCurrentParameterCount(); i++) {
			ret = ret && ((AICommand)this.getParameter(i)).isConstant();
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		boolean ret = false;
		if (inclusiveParameter) {
			for (int i=0; i<this.getCurrentParameterCount(); i++) {
				ret = ret || ((AICommand)this.getParameter(i)).hasSideEffects(inclusiveParameter);
			}
		}
		return ret;
	}
}
