package commands;





public class ITECommand extends AICommand {
	
	@Override
	public String getShortName() {
		return "ITE";
	}
	
	@Override
	public String getLongName() {
		return "IfThenElse";
	}
	
	@Override
	public int getParameterCount() {
		return 3;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int condition = 0;
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			condition = getParameter(0).doCommand(withSideEffects);
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing first parameter");
		}
		if (stop) {
			return 0;
		}
		logExecute(this.getClass().getName() + ".doCommand()", ",");
		if (getParameter(1) != null) {
			if (isTrue(condition)) {
				ret = getParameter(1).doCommand(withSideEffects);
			}
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing second parameter");
		}
		if (stop) {
			return 0;
		}
		logExecute(this.getClass().getName() + ".doCommand()", ",");
		if (getParameter(2) != null) {
			if (!isTrue(condition)) {
				ret = getParameter(2).doCommand(withSideEffects);
			}
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing third parameter");
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	public ITECommand() {
		super();
	}

	public ITECommand(ITECommand src) {
		super(src);
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new ITECommand(this);
		}
		return null;
	}

	@Override
	public IAICommand copy() {
		return new ITECommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		boolean ret = true;
		if (this.getCurrentParameterCount() > 0) {
			if (((AICommand)this.getParameter(0)).isConstant()) {
				if (isTrue(this.getParameter(0).doCommand(false))) {
					// 1. parameter const and positive
					// see second parameter
					if (this.getCurrentParameterCount() > 1) {
						ret = ((AICommand)this.getParameter(1)).isConstant();
					} else {
						// Error
						ret = true;
					}
				} else {
					// 1. parameter const and negativ
					// see third parameter
					if (this.getCurrentParameterCount() > 2) {
						ret = ((AICommand)this.getParameter(2)).isConstant();
					} else {
						// Error
						ret = true;
					}
				}
			} else {
				// 1. parameter not const result always not const
				ret = false;
			}
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		switch (paramID) {
		case 0: return IsExecutedType.ALWAYS;
		case 1: {
				if (this.getCurrentParameterCount() > 0) {
					if (((AICommand)this.getParameter(0)).isConstant()) {
						if (isTrue(this.getParameter(0).doCommand(false))) {
							return IsExecutedType.ALWAYS;
						} else {
							return IsExecutedType.NEVER;
						}
					} else {
						return IsExecutedType.MAYBE;
					}
				}
			} break;
		case 2: {
			if (this.getCurrentParameterCount() > 0) {
				if (((AICommand)this.getParameter(0)).isConstant()) {
					if (isTrue(this.getParameter(0).doCommand(false))) {
						return IsExecutedType.NEVER;
					} else {
						return IsExecutedType.ALWAYS;
					}
				} else {
					return IsExecutedType.MAYBE;
				}
			}
		} break;
		}
		return IsExecutedType.NEVER;
	}


	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		boolean ret = false;
		if (inclusiveParameter) {
			if (this.getCurrentParameterCount() > 0) {
				ret = ret || ((AICommand)this.getParameter(0)).hasSideEffects(inclusiveParameter);
			}
			if (this.getCurrentParameterCount() > 1) {
				if (IsExecutedType.NEVER != this.isParameterExecuted(1)) {
					ret = ret || ((AICommand)this.getParameter(1)).hasSideEffects(inclusiveParameter);
				}
			}
			if (this.getCurrentParameterCount() > 2) {
				if (IsExecutedType.NEVER != this.isParameterExecuted(2)) {
					ret = ret || ((AICommand)this.getParameter(2)).hasSideEffects(inclusiveParameter);
				}
			}
		}
		return ret;
	}
}
