package commands;

import simulation.ICommunicationToSimulation;

import commands.KeyCommand.Type;

public class Key2Command extends AICommand implements IAICommand {

	private ICommunicationToSimulation communication = null;
		
	public void setCommunication(ICommunicationToSimulation newCommunication) {
		communication = newCommunication;
	}
	
	public ICommunicationToSimulation getCommunication() {
		return communication;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			ret = getParameter(0).doCommand(withSideEffects);
			if ((withSideEffects) && (!stop)) {
				if (communication != null) {
					communication.sendGameKeys((int)(ret / 1000), Type.PRESS);
					communication.sendGameKeys((int)(ret / 1000), Type.RELEASE);
				} else {
					logError(this.getClass().getName() + ".doCommand()","No communication found");
				}
			}
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public String getLongName() {
		return "SendKey";
	}

	@Override
	public int getParameterCount() {
		return 1;
	}

	@Override
	public String getShortName() {
		return "KEY";
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new Key2Command(this);
		}
		return null;
	}

	public Key2Command() {
		super();
	}
	
	public Key2Command(Key2Command src) {
		super(src);
		this.setCommunication(src.getCommunication());
	}

	@Override
	public IAICommand copy() {
		return new Key2Command(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// all parameters must be const to be const
		boolean ret = true;
		for (int i=0; i<this.getCurrentParameterCount(); i++) {
			ret = ret && ((AICommand)this.getParameter(i)).isConstant();
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		return true;
	}
}
