package commands;

import simulation.ICommunicationToSimulation;

public class KeyCommand extends AICommand implements IAICommand {

	private ICommunicationToSimulation communication = null;
	
	public enum Type {
		PRESS, RELEASE;
	}
	
	private Type type = Type.PRESS;
	
	public void setCommunication(ICommunicationToSimulation newCommunication) {
		communication = newCommunication;
	}
	
	public ICommunicationToSimulation getCommunication() {
		return communication;
	}

	public Type setType(Type newType) {
		type = newType;
		return type;
	}
	
	public Type getType() {
		return type;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand(" + (type == Type.PRESS ? "PRESS" : "RELEASE") + ")", getLongName() + "(");
		if (getParameter(0) != null) {
			ret = getParameter(0).doCommand(withSideEffects);
			if ((withSideEffects) && (!stop)) {
				if (communication != null) {
					communication.sendGameKeys((int)(ret / 1000), type);
				} else {
					logError(this.getClass().getName() + ".doCommand(" + (type == Type.PRESS ? "PRESS" : "RELEASE") + ")","No communication found");
				}
			}
		}
		logExecute(this.getClass().getName() + ".doCommand(" + (type == Type.PRESS ? "PRESS" : "RELEASE") + ")", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public String getLongName() {
		return "SendKey" + (type == Type.PRESS ? "Press" : "Release");
	}

	@Override
	public int getParameterCount() {
		return 1;
	}

	@Override
	public String getShortName() {
		return "KEY" + (type == Type.PRESS ? "P" : "R");
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if ((string.equals("KEYP")) || (string.equals("KEYR"))) {
			KeyCommand ret = new KeyCommand(this);
			if (string.equals("KEYP")) {
				ret.setType(Type.PRESS);
			} else {
				ret.setType(Type.RELEASE);
			}
			return ret;
		}
		return null;
	}

	public KeyCommand() {
		super();
	}
	
	public KeyCommand(KeyCommand src) {
		super(src);
		this.setCommunication(src.getCommunication());
		this.setType(src.getType());
	}

	@Override
	public IAICommand copy() {
		return new KeyCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// all parameters must be const to be const
		boolean ret = true;
		for (int i=0; i<this.getCurrentParameterCount(); i++) {
			ret = ret && ((AICommand)this.getParameter(i)).isConstant();
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		return true;
	}
}
