package commands;

import java.util.Random;


public class NumberCommand extends AICommand {
	
	private int Float = 0;
	
	@Override
	public String getShortName() {
		return String.format("%6d", Float).trim();
	}
		
	@Override
	public String getLongName() {
		return String.format("%3d.%03d", (int)(Float/1000), (int)(Float%1000)).trim();
	}
	
	@Override
	public int getParameterCount() {
		return 0;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + Float);
		return Float;
	}

	@Override
	public IAICommand isThisCommand(String string) {
		try {
			int value = Integer.valueOf(string);
			NumberCommand ret = new NumberCommand(this);
			ret.setNumber(value);
			return ret;
		} catch (NumberFormatException e) {
			return null;
		}
	}

	public NumberCommand() {
		super();
		Float = (int)(Math.random() * 200000) - 100000;
	}
	
	public NumberCommand(NumberCommand src) {
		super(src);
		Float = src.Float;
	}
		
	@Override
	public void setRandomValue(Random random) {
		Float = (int)(random.nextDouble() * 200000) - 100000;
	}

	public void setNumber(int number) {
		Float = number;
	}

	public int getNumber() {
		return Float;
	}

	@Override
	public IAICommand copy() {
		return new NumberCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		NumberCommand ret = new NumberCommand();
		ret.setLogger(this.getLogger());
		return ret;
	}

	@Override
	public boolean isConstant() {
		// Always const
		return true;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.NEVER;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		return false;
	}
}
