package commands;





public class OrCommand extends AICommand {
	
	@Override
	public String getShortName() {
		return "OR";
	}
	
	@Override
	public String getLongName() {
		return "OR";
	}
	
	@Override
	public int getParameterCount() {
		return 2;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			ret = getParameter(0).doCommand(withSideEffects);
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing first parameter");
		}
		if (stop) {
			return 0;
		}
		logExecute(this.getClass().getName() + ".doCommand()", ",");
		if (getParameter(1) != null) {
			if (!isTrue(ret)) {
				ret = getParameter(1).doCommand(withSideEffects);
			}
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing second parameter");
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	public OrCommand() {
		super();
	}

	public OrCommand(OrCommand src) {
		super(src);
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new OrCommand(this);
		}
		return null;
	}

	@Override
	public IAICommand copy() {
		return new OrCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		boolean ret = true;
		if (this.getCurrentParameterCount() > 0) {
			if (((AICommand)this.getParameter(0)).isConstant()) {
				if (!isTrue(this.getParameter(0).doCommand(false))) {
					// 1. parameter const and negative
					// see second parameter
					if (this.getCurrentParameterCount() > 1) {
						ret = ((AICommand)this.getParameter(1)).isConstant();
					} else {
						// Error
						ret = true;
					}
				} else {
					// 1. parameter const and positive
					// result always first parameter
					ret = true;
				}
			} else {
				// 1. parameter not const result always not const
				ret = false;
			}
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		switch (paramID) {
		case 0: return IsExecutedType.ALWAYS;
		case 1: {
				if (this.getCurrentParameterCount() > 0) {
					if (((AICommand)this.getParameter(0)).isConstant()) {
						if (isTrue(this.getParameter(0).doCommand(false))) {
							return IsExecutedType.NEVER;
						} else {
							return IsExecutedType.ALWAYS;
						}
					} else {
						return IsExecutedType.MAYBE;
					}
				}
			} break;
		}
		return IsExecutedType.NEVER;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		boolean ret = false;
		if (inclusiveParameter) {
			if (this.getCurrentParameterCount() > 0) {
				ret = ret || ((AICommand)this.getParameter(0)).hasSideEffects(inclusiveParameter);
			}
			if (this.getCurrentParameterCount() > 1) {
				if (IsExecutedType.NEVER != this.isParameterExecuted(1)) {
					ret = ret || ((AICommand)this.getParameter(1)).hasSideEffects(inclusiveParameter);
				}
			}
		}
		return ret;
	}
}
