package commands;

import mainClasses.GALibrary;
import mainClasses.GAProgram;


public class ProgCommand extends AICommand {
	
	private int ID = 0;
	
	private GALibrary library = null;
	
	@Override
	public String getShortName() {
		return String.format("PROG%6d", ID).trim();
	}
		
	@Override
	public String getLongName() {
		return String.format("PROG%6d", ID).trim();
	}
	
	@Override
	public int getParameterCount() {
		return 0;
	}
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		GAProgram program = this.library.getProgram(this.ID);
		int ret = program.getProgram().doCommand(withSideEffects);
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.length() > 4) {
			String code = string.substring(0,4);
			String id = string.substring(4);
			if (code.equalsIgnoreCase("PROG")) {
				try {
					int progID = Integer.valueOf(id);
					ProgCommand ret = new ProgCommand(this);
					ret.setProgID(progID);
					return ret;
				} catch (NumberFormatException e) {
					return null;
				}
			} else {
				return null;
			}
		} else {
			return null;
		}
	}

	public ProgCommand() {
		super();
		this.library = null;
		this.ID = -1;
	}
	
	public ProgCommand(ProgCommand src) {
		super(src);
		this.library = src.library;
		this.ID = src.ID;
	}
		
	public int setProgID(int progID) {
		this.ID = progID;
		return this.ID;
	}

	public int getProgID() {
		return this.ID;
	}

	public GALibrary setLibrary(GALibrary library) {
		this.library = library;
		return this.library;
	}
	
	public GALibrary getLibrary() {
		return this.library;
	}
	
	@Override
	public IAICommand copy() {
		return new ProgCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		ProgCommand ret = new ProgCommand();
		ret.setLogger(this.getLogger());
		return ret;
	}

	@Override
	public boolean isConstant() {
		GAProgram program = this.library.getProgram(this.ID);
		if (program == null) {
			return false;
		} else {
			return ((AICommand)program.getProgram()).isConstant();
		}
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.NEVER;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		GAProgram program = this.library.getProgram(this.ID);
		if (program == null) {
			return false;
		} else {
			return ((AICommand)program.getProgram()).hasSideEffects(inclusiveParameter);
		}
	}
}
