package commands;

import simulation.Memory;

public class ReadCommand extends AICommand implements IAICommand {

	private Memory memory = null;
	
	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			int pos = (int)(getParameter(0).doCommand(withSideEffects) / 1000);
			if (!stop) {
				if (memory != null) {
					ret = memory.getValue(pos);
				} else {
					logError(this.getClass().getName() + ".doCommand()","Memory not found");
				}
			}
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public String getLongName() {
		return "ReadMemory";
	}

	@Override
	public int getParameterCount() {
		return 1;
	}

	@Override
	public String getShortName() {
		return "READ";
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new ReadCommand(this);
		}
		return null;
	}

	public void setMemory(Memory mem) {
		memory = mem;
	}
	
	public ReadCommand() {
		super();
	}
	
	public ReadCommand(ReadCommand src) {
		super(src);
	}

	@Override
	public IAICommand copy() {
		return new ReadCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// always not const
		return false;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		return true;
	}
}
