package commands;


public class SleepCommand extends AICommand implements IAICommand {

	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			int value = Math.abs((int)(getParameter(0).doCommand(withSideEffects) / 1000));
			if ((withSideEffects) && (!stop)) {
				for (int i=value/100; i>0; i++) {
					try {
						Thread.sleep(100);
					} catch (InterruptedException e) {
					}
					if (stop) break;
				}
				if (!stop) {
					try {
						Thread.sleep(value%100);
					} catch (InterruptedException e) {
					}
				}
			}
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing first parameter");
		}
		if (stop) {
			return 0;
		}
		logExecute(this.getClass().getName() + ".doCommand()", ",");
		if (getParameter(1) != null) {
			ret = ret + getParameter(1).doCommand(withSideEffects);
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing second parameter");
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public String getLongName() {
		return "Sleep";
	}

	@Override
	public int getParameterCount() {
		return 2;
	}

	@Override
	public String getShortName() {
		return "SLEEP";
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new SleepCommand(this);
		}
		return null;
	}

	public SleepCommand() {
		super();
	}
	
	public SleepCommand(SleepCommand src) {
		super(src);
	}

	@Override
	public IAICommand copy() {
		return new SleepCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// all parameters must be const to be const
		boolean ret = true;
		if (this.getParameter(1) != null) {
			ret = ((AICommand)this.getParameter(1)).isConstant();
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		return true;
	}
}
