package commands;


public class SumCommand extends AICommand implements IAICommand {

	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			int count = getParameter(0).doCommand(withSideEffects) / 1000;
			if (count > 1000) {
				count = 1000;
			}
			if (getParameter(1) != null) {
				for (int i=0; i<count; i++) {
					if (stop) break;
					ret = ret + getParameter(1).doCommand(withSideEffects);
				}
			} else {
				logError(this.getClass().getName() + ".doCommand()", "Missing second parameter");
			}
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing first parameter");
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public String getLongName() {
		return "Sum";
	}

	@Override
	public int getParameterCount() {
		return 2;
	}

	@Override
	public String getShortName() {
		return "SUM";
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new SumCommand(this);
		}
		return null;
	}

	public SumCommand() {
		super();
	}
	
	public SumCommand(SumCommand src) {
		super(src);
	}

	@Override
	public IAICommand copy() {
		return new SumCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		// all parameters must be const to be const
		boolean ret = true;
		for (int i=0; i<this.getCurrentParameterCount(); i++) {
			ret = ret && ((AICommand)this.getParameter(i)).isConstant();
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		if (paramID == 0) {
			return IsExecutedType.ALWAYS;
		} else {
			if (this.getParameterCount() > 0) {
				if (((AICommand)this.getParameter(0)).isConstant()) {
					int value = this.getParameter(0).doCommand(true) / 1000;
					if (value < 1) {
						return IsExecutedType.NEVER;
					} else {
						return IsExecutedType.ALWAYS;
					}
				}
			}
			return IsExecutedType.MAYBE;
		}
	}

	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		boolean ret = false;
		if (inclusiveParameter) {
			for (int i=0; i<this.getCurrentParameterCount(); i++) {
				ret = ret || ((AICommand)this.getParameter(i)).hasSideEffects(inclusiveParameter);
			}
		}
		return ret;
	}
}
