package commands;

import simulation.Memory;

public class WriteCommand extends AICommand implements IAICommand {

	private Memory memory = null;

	@Override
	public int doCommand() {
		return doCommand(true);
	}
	
	@Override
	public int doCommand(boolean withSideEffects) {
		if (stop) {
			return 0;
		}
		int ret = 0;
		logExecute(this.getClass().getName() + ".doCommand()", getLongName() + "(");
		if (getParameter(0) != null) {
			int pos = (int)(getParameter(0).doCommand(withSideEffects) / 1000);
			logExecute(this.getClass().getName() + ".doCommand()", ",");
			if (getParameter(1) != null) {
				ret = getParameter(1).doCommand(withSideEffects);
				if ((withSideEffects) && (!stop)) {
					if (memory != null) {
						ret = memory.setValue(pos,ret);
					} else {
						logError(this.getClass().getName() + ".doCommand()","Memory not found");
					}
				}
			} else {
				logError(this.getClass().getName() + ".doCommand()", "Missing second parameter");
			}
		} else {
			logError(this.getClass().getName() + ".doCommand()", "Missing first parameter");
		}
		logExecute(this.getClass().getName() + ".doCommand()", ")" + getLongName() + " = " + ret);
		return ret;
	}

	@Override
	public String getLongName() {
		return "WriteMemory";
	}

	@Override
	public int getParameterCount() {
		return 2;
	}

	@Override
	public String getShortName() {
		return "WRITE";
	}

	@Override
	public IAICommand isThisCommand(String string) {
		if (string.equals(getShortName())) {
			return new WriteCommand(this);
		}
		return null;
	}

	public void setMemory(Memory mem) {
		memory = mem;
	}

	public WriteCommand() {
		super();
	}
	
	public WriteCommand(WriteCommand src) {
		super(src);
	}

	@Override
	public IAICommand copy() {
		return new WriteCommand(this);
	}

	@Override
	public IAICommand copyRandom() {
		return copy();
	}

	@Override
	public boolean isConstant() {
		boolean ret = true;
		if (this.getCurrentParameterCount() > 1) {
			if (((AICommand)this.getParameter(1)).isConstant()) {
				ret = true;
			} else {
				ret = false;
			}
		}
		return ret;
	}
	
	@Override
	public IsExecutedType isParameterExecuted(int paramID) {
		return IsExecutedType.ALWAYS;
	}


	@Override
	public boolean hasSideEffects(boolean inclusiveParameter) {
		return true;
	}
}
