package extern;

/**
 * The <code>Ship</code> class represents the players space ship.
 * <p>
 * An space ship has a position and an orientation.
 * @see GameStatus
 */
public class Ship extends Position {
	protected Position orientation;

	/**
	 * Initializes a new space ship with given position and orientation.
	 *
	 * @param x
	 *        x-coordinate
	 *
	 * @param y
	 *        y-coordinate
	 *
	 * @param dx
	 *        orientation x-component
	 *
	 * @param dy
	 *        orientation y-component
	 */
	public Ship(int x, int y, int dx, int dy) {
		super(x, y);
		orientation = new Position(dx, dy);
	}

	/**
	 * Returns the space ships orientation.
	 *
	 * @return the orientation
	 */
	public Position getOrientation() {
		return orientation;
	}

	/**
	 * Sets the space ships orientation.
	 *
	 * @param orientation
	 * 			the orientation
	 */
	public void setOrientation(Position orientation) {
		this.orientation = orientation;
	}
}
