package global;

import java.util.ArrayList;
import java.util.List;

import commands.AICommand;
import commands.IAICommand;

public class CreateProgramTree {

	private List<IAICommand> commandList = null;
	
	private Logger logger = null;
	
	public CreateProgramTree() {
		commandList = new ArrayList<IAICommand>();
	}
	
	public void setLogger(Logger newLogger) {
		logger = newLogger;
	}
	
	public void addCommand(IAICommand command) {
		if (command != null) {
			commandList.add(command);
		}
	}
	
	public void addCommands(List<IAICommand> list) {
		for (int i=0; i<list.size(); i++) {
			commandList.add(list.get(i));
		}
	}
	
	public void clearCommandList() {
		commandList.clear();
	}
	
	public IAICommand findCommand(String code) {
		IAICommand ret = null;
		if (commandList == null) {
			if (logger != null) {
				logger.LogError("CreateProgramTree.findCommand", "no command list");
			}
			return null;
		}
		for (int i=0; i<commandList.size(); i++) {
			if (commandList.get(i) != null) {
				ret = commandList.get(i).isThisCommand(code);
				if (ret != null) {
					break;
				}
			}
		}
		if (ret == null) {
			if (logger != null) {
				logger.LogError("CreateProgramTree.findCommand", "command not found: " + code);
			}
		}
		return ret;
	}
	
	public int createTree(String[] codes, int pos, AICommand root) {
		if (root == null) {
			return pos;
		}
		for (int i=0; i<root.getParameterCount(); i++) {
			if (pos < codes.length) {
				IAICommand param = null;
				param = findCommand(codes[pos]);
				if (param != null) {
					root.addParameter(param);
					pos = createTree(codes, pos + 1, (AICommand) param);
				}
			}
		}
		return pos;
	}
	
	public IAICommand interpret(String code) {
		String[] codes = code.split(" ");
		IAICommand ret = null;
		if (codes.length > 0) {
			ret = findCommand(codes[0]);
			if (ret != null) {
				createTree(codes, 1, (AICommand) ret);
			}
		}
		return ret;
	}
}
