package global;

import java.util.ArrayList;
import java.util.List;


public class Logger {

	private List<LogEntry> log = null;
	
	public Logger() {
		log = new ArrayList<LogEntry>();
	}
	
	public void Log(String method, String text, LogType type) {
		LogEntry newEntry = new LogEntry();
		newEntry.method = method;
		newEntry.text = text;
		newEntry.type = type;
		log.add(newEntry);
	}
	
	public void LogError(String method, String text) {
		Log(method, text, LogType.ERROR);
	}
	
	public void LogExecute(String method, String text) {
		Log(method, text, LogType.EXECUTE);
	}
	
	public void clear() {
		log.clear();
	}
	
	public String getLog() {
		String ret = "<log>\n";
		for (int i=0; i<log.size(); i++) {
			LogEntry entry = log.get(i);
			ret = ret + "<entry function=\"" + entry.method + "\" type=\"";
			switch (entry.type) {
			case ERROR: ret = ret + "ERROR"; break;
			case NONE: ret = ret + "NONE"; break;
			case WARNING: ret = ret + "WARNING"; break;
			case NORMAL: ret = ret + "NORMAL"; break;
			case EXECUTE: ret = ret + "EXECUTE"; break;
			}
			ret = ret + "\">";
			ret = ret + entry.text;
			ret = ret + "</entry>\n";
		}
		return ret + "</log>\n";
	}
}
