package globalTests;

import global.CreateProgramTree;
import global.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import commands.AICommand;
import commands.AddCommand;
import commands.KeyCommand;
import commands.NumberCommand;
import commands.SleepCommand;

public class CreateProgramTreeTest extends TestCase {

	private CreateProgramTree cpt = null;
	
	private AddCommand addCommand = null;
	
	private NumberCommand numberCommand = null;
	
	private Logger logger = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		logger = new Logger();
		cpt = new CreateProgramTree();
		cpt.setLogger(logger);
		addCommand = new AddCommand();
		addCommand.setLogger(logger);
		numberCommand = new NumberCommand();
		numberCommand.setLogger(logger);
		cpt.addCommand(addCommand);
		cpt.addCommand(numberCommand);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testFindCommandOK() {
		AICommand cmd = (AICommand) cpt.findCommand("ADD");
		if (cmd != null) {
			assertEquals("ADD", cmd.getShortName());
		} else {
			fail("Command not found");
		}
	}
	
	public void testNotFindCommand() {
		try {
			AICommand cmd = (AICommand) cpt.findCommand("FALSCH");
			if (cmd != null) {
				fail("Not existing command found");
			}
		} catch (Exception e) {
			fail("Exception: " + e.getMessage());
		}
	}

	public void testCreateTreeOK() {
		String[] codes = { "ADD", "ADD", "123456", "654321", "111111" };
		AddCommand root = new AddCommand();
		cpt.createTree(codes, 1, root);
		assertEquals(2,root.getCurrentParameterCount());
		assertEquals("ADD",((AICommand)root.getParameter(0)).getShortName());
		assertEquals("111111",((AICommand)root.getParameter(1)).getShortName());
		AICommand subItem = ((AICommand)root.getParameter(0));
		assertEquals(2,subItem.getCurrentParameterCount());
		assertEquals("123456",((AICommand)subItem.getParameter(0)).getShortName());
		assertEquals("654321",((AICommand)subItem.getParameter(1)).getShortName());
	}
	
	public void testCreateTreeMissingParameters() {
		String[] codes2 = { "ADD", "ADD" };
		AddCommand root2 = new AddCommand();
		try {
			cpt.createTree(codes2, 1, root2);
		} catch (Exception e){
			fail("No exception expected even if there are too less parameters: " + e.getMessage());
		}
	}

	public void testCreateTreeFalseCommand() {
		String[] codes2 = { "ADD", "NONESENSEE" };
		AddCommand root2 = new AddCommand();
		try {
			cpt.createTree(codes2, 1, root2);
		} catch (Exception e){
			fail("No exception expected even by wrong command name: " + e.getMessage());
		}
	}

	public void testInterpretOK() {
		AICommand root = (AICommand) cpt.interpret("ADD ADD 123456 654321 111111");
		assertEquals("ADD",root.getShortName());
		assertEquals("ADD",((AICommand)root.getParameter(0)).getShortName());
		assertEquals("111111",((AICommand)root.getParameter(1)).getShortName());
		AICommand subItem = ((AICommand)root.getParameter(0));
		assertEquals("123456",((AICommand)subItem.getParameter(0)).getShortName());
		assertEquals("654321",((AICommand)subItem.getParameter(1)).getShortName());
	}
	
	public void testInterpret2() {
		KeyCommand keyCommand = new KeyCommand();
		keyCommand.setLogger(logger);
		cpt.addCommand(keyCommand);
		SleepCommand sleepCommand = new SleepCommand();
		sleepCommand.setLogger(logger);
		cpt.addCommand(sleepCommand);
		AICommand root = null;
		try {
			root = (AICommand) cpt.interpret("ADD KEYP 1000 SLEEP 1000 KEYR 1000");
		} catch (Exception e) {
			fail("No exception expected during interpretation: " + e.getMessage());
		}
		try {
			assertEquals("ADD",root.getShortName());
		} catch (Exception e) {
			fail("No exception expected by getting name of root element: " + e.getMessage());
		}
		try {
			assertEquals(2, root.getCurrentParameterCount());
			assertEquals("KEYP",((AICommand)root.getParameter(0)).getShortName());
			assertEquals("SLEEP",((AICommand)root.getParameter(1)).getShortName());
			AICommand si = (AICommand)root.getParameter(0);
			assertEquals(1, si.getCurrentParameterCount());
			assertEquals("1000",((AICommand)si.getParameter(0)).getShortName());
			si = (AICommand)root.getParameter(1);
			assertEquals(2, si.getCurrentParameterCount());
			assertEquals("1000",((AICommand)si.getParameter(0)).getShortName());
			assertEquals("KEYR",((AICommand)si.getParameter(1)).getShortName());
			si = (AICommand)si.getParameter(1);
			assertEquals(1, si.getCurrentParameterCount());
			assertEquals("1000", ((AICommand)si.getParameter(0)).getShortName());
			assertEquals("<log>\n</log>\n",logger.getLog());
			root.doCommand();
		} catch (Exception e) {
			fail("No exception expected during tree checking: " + e.getMessage());
		}
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("CreateProgramTree");
		suite.addTestSuite(CreateProgramTreeTest.class);
		return suite;
	}
}
