package globalTests;

import global.LogType;
import global.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class LoggerTest extends TestCase {

	private Logger logger = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		logger = new Logger();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testLog() {
		logger.Log("a", "b", LogType.NORMAL);
		assertEquals("<log>\n<entry function=\"a\" type=\"NORMAL\">b</entry>\n</log>\n",logger.getLog());
	}

	public void testLogError() {
		logger.LogError("a", "b");
		assertEquals("<log>\n<entry function=\"a\" type=\"ERROR\">b</entry>\n</log>\n",logger.getLog());
	}

	public void testLogExecute() {
		logger.LogExecute("a", "b");
		assertEquals("<log>\n<entry function=\"a\" type=\"EXECUTE\">b</entry>\n</log>\n",logger.getLog());
	}

	public void testClear() {
		logger.LogExecute("a", "b");
		logger.clear();
		logger.Log("a", "b", LogType.NORMAL);
		assertEquals("<log>\n<entry function=\"a\" type=\"NORMAL\">b</entry>\n</log>\n",logger.getLog());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("Logger");
		suite.addTestSuite(LoggerTest.class);
		return suite;
	}
}
