package gui;

import global.CreateProgramTree;
import mainClasses.ExecutionManager;
import mainClasses.GALoad;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LoadAdapter implements SelectionListener {

	private CreateProgramTree createProgramTree = null;
	
	private Shell shell = null;
	
	private ExecutionManager manager = null;

	public LoadAdapter(ExecutionManager manager, Shell newShell) {
		this.manager = manager;
		shell = newShell;
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {
		FileDialog dialog = new FileDialog(shell, SWT.OPEN);
		dialog.setText("Open");
		dialog.setFilterPath(".");
		dialog.setFilterExtensions(new String [] { "*.ga" });
		String filename = dialog.open();
		if (filename != null) {
			GALoad load = new GALoad();
			load.setCreateProgramTree(createProgramTree);
			load.load(filename, manager);
			this.manager.setFilename(filename);
		}
	}

	public void setCreateProgramTree(CreateProgramTree newCreateProgramTree) {
		createProgramTree = newCreateProgramTree;
	}

	public void setExecutionManager(ExecutionManager manager) {
		this.manager = manager;
	}
}
