package gui;

import global.CreateProgramTree;
import mainClasses.ExecutionManager;
import mainClasses.GAGenerationGenerator;
import mainClasses.GAPopulation;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;


public class MainWindow {
	
	private ExitAdapter exitAdapter = null;
	
	private SaveAdapter saveAdapter = null;
	
	private LoadAdapter loadAdapter = null;
	
	private MergeAdapter mergeAdapter = null;
	
	private NewAdapter newAdapter = null;
	
	private ShowPopulationAdapter showPopulationAdapter = null;
	
	private PopulationGenerateAdapter populationGenerateAdapter = null;
		
	private NewServerAdapter newServerAdapter = null;
	
	private ServerConsoleAdapter serverConsoleAdapter = null;
	
	private ServerListAdapter serverListAdapter = null;
	
	private JustStartBestAdapter justStartBestAdapter = null;
	
	private StatisticAdapter statisticAdapter = null;
	
	private GAPopulation population = null;
	
	private GAGenerationGenerator generationGenerator = null;
	
	private CreateProgramTree createProgramTree = null;
	
	private ExecutionManager executionManager = null;
	
	private Display display = null;

	private Shell shell = null;
		
	public MainWindow() {
		display = new Display();
		shell = new Shell(display);
		
		shell.setText("Asteroids Player");
		CreateListener(shell);
		CreateMenuBar(shell);
		shell.setLayout(new FillLayout());

		Text text = new Text(shell,SWT.BORDER | SWT.READ_ONLY | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		text.setText("Program: (c) by Sebastian Sprl - 2008\n" +
				"Example program by c't 2008\n" +
				"Example program translated to Java by unknown 2008\n\n" +
				"Attention: start first c't-Mame (start button patch; german language) with the Asteroids game\n" +
				"Then load the last generation\n" + 
				"Select Infos -> Just Start Best\n" +
				"Select Infos -> Server Console -> \"Automatic\" OR \"Start One\"-> close window\n" +
				"now the game will automatically start");
	}
	
	public void open() {
		shell.open();
		
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		display.dispose();
	}
	
	private void CreateListener(Shell shell) {
		exitAdapter = new ExitAdapter();
		saveAdapter = new SaveAdapter(this.executionManager, shell);
		loadAdapter = new LoadAdapter(this.executionManager, shell);
		populationGenerateAdapter = new PopulationGenerateAdapter(population, generationGenerator);
		newAdapter = new NewAdapter(shell, populationGenerateAdapter);
		showPopulationAdapter = new ShowPopulationAdapter(shell);
		newServerAdapter = new NewServerAdapter(this.executionManager, shell);
		if (this.executionManager != null) {
			serverConsoleAdapter = new ServerConsoleAdapter(this.executionManager.getServer(0), shell);
		} else {
			serverConsoleAdapter = new ServerConsoleAdapter(null, shell);
		}
		serverListAdapter = new ServerListAdapter(this.executionManager, shell);
		justStartBestAdapter = new JustStartBestAdapter(this.executionManager);
		statisticAdapter = new StatisticAdapter(population, shell);
		mergeAdapter = new MergeAdapter(this.executionManager, this.createProgramTree, shell);
	}
	
	private void CreateMenuBar(Shell shell) {
		Menu menu = new Menu(shell, SWT.BAR);
		shell.setMenuBar(menu);
		
		MenuItem menuItemFile = new MenuItem(menu, SWT.CASCADE);
		menuItemFile.setText("File");
		
		Menu menuFile = new Menu(shell, SWT.DROP_DOWN);
		menuItemFile.setMenu(menuFile);
	
		MenuItem menuItemFileNew = new MenuItem(menuFile, SWT.PUSH);
		menuItemFileNew.setText("New");
		menuItemFileNew.addSelectionListener(newAdapter);
		
		MenuItem menuItemFileSave = new MenuItem(menuFile, SWT.PUSH);
		menuItemFileSave.setText("Save");
		menuItemFileSave.addSelectionListener(saveAdapter);

		MenuItem menuItemFileLoad = new MenuItem(menuFile, SWT.PUSH);
		menuItemFileLoad.setText("Load");
		menuItemFileLoad.addSelectionListener(loadAdapter);
		
		MenuItem menuItemFileMerge = new MenuItem(menuFile, SWT.PUSH);
		menuItemFileMerge.setText("Merge");
		menuItemFileMerge.addSelectionListener(mergeAdapter);

		MenuItem menuItemFileExit = new MenuItem(menuFile, SWT.PUSH);
		menuItemFileExit.setText("Exit");
		menuItemFileExit.addSelectionListener(exitAdapter);

		MenuItem menuItemInfos = new MenuItem(menu, SWT.CASCADE);
		menuItemInfos.setText("Infos");
		
		Menu menuInfos = new Menu(shell, SWT.DROP_DOWN);
		menuItemInfos.setMenu(menuInfos);
	
		MenuItem menuItemInfosJustStartBest = new MenuItem(menuInfos, SWT.CHECK);
		menuItemInfosJustStartBest.setText("Just Start Best");
		menuItemInfosJustStartBest.addSelectionListener(justStartBestAdapter);
		
		MenuItem menuItemInfosPopulation = new MenuItem(menuInfos, SWT.PUSH);
		menuItemInfosPopulation.setText("Population");
		menuItemInfosPopulation.addSelectionListener(showPopulationAdapter);

		MenuItem menuItemInfosStatistic = new MenuItem(menuInfos, SWT.PUSH);
		menuItemInfosStatistic.setText("Statistic");
		menuItemInfosStatistic.addSelectionListener(statisticAdapter);

		MenuItem menuItemInfosServerList = new MenuItem(menuInfos, SWT.PUSH);
		menuItemInfosServerList.setText("Serverlist");
		menuItemInfosServerList.addSelectionListener(serverListAdapter);

		MenuItem menuItemInfosServer = new MenuItem(menuInfos, SWT.PUSH);
		menuItemInfosServer.setText("AddServer");
		menuItemInfosServer.addSelectionListener(newServerAdapter);

		MenuItem menuItemInfosServerConsole = new MenuItem(menuInfos, SWT.PUSH);
		menuItemInfosServerConsole.setText("Server Console");
		menuItemInfosServerConsole.addSelectionListener(serverConsoleAdapter);
	}

	public void setPopulation(GAPopulation newPopulation) {
		population = newPopulation;
		populationGenerateAdapter.setPopulation(population);
		showPopulationAdapter.setPopulation(population);
		statisticAdapter.setPopulation(population);
	}

	public void setGenerationGenerator(GAGenerationGenerator newGenerationGenerator) {
		generationGenerator = newGenerationGenerator;
		populationGenerateAdapter.setGenerationGenerator(generationGenerator);
	}
	
	public void setCreateProgramTree(CreateProgramTree newCreateProgramTree) {
		this.createProgramTree = newCreateProgramTree;
		loadAdapter.setCreateProgramTree(this.createProgramTree);
		mergeAdapter.setCreateProgramTree(this.createProgramTree);
	}
	
	public void setExecutionManager(ExecutionManager manager) {
		executionManager = manager;
		serverConsoleAdapter.setServerController(executionManager.getServer(0));
		serverListAdapter.setExecutionManager(manager);
		newServerAdapter.setExecutionManager(manager);
		loadAdapter.setExecutionManager(manager);
		saveAdapter.setExecutionManager(manager);
		justStartBestAdapter.setExecutionManager(manager);
		mergeAdapter.setExecutionManager(manager);
	}
}
