package gui;


import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


public class NewComposite extends Composite {

	private PopulationGenerateAdapter populationGenerateAdapter = null;
	
	private Text populationSize = null;
	
	private Text programDepth = null;
	
	public NewComposite(Composite parent, PopulationGenerateAdapter newPopulationGenerateAdapter, int style) {
		super(parent, style);
		
		this.setLayout(new RowLayout(SWT.VERTICAL));
		
		populationGenerateAdapter = newPopulationGenerateAdapter;
		
		new Label(this, SWT.NONE).setText("Generation size:");
		populationSize = new Text(this, SWT.BORDER);
		populationSize.setText("500");
		
		new Label(this, SWT.NONE).setText("Max Program Depth");
		programDepth = new Text(this, SWT.BORDER);
		programDepth.setText("10");
		
		Button okButton = new Button(this, SWT.BORDER);
		okButton.setText(" Generate ");
		okButton.addSelectionListener(populationGenerateAdapter);
		
		populationGenerateAdapter.setComposite(this);

		this.pack();
	}

	public int getPopulationSize() {
		return Integer.valueOf(populationSize.getText());
	}

	public int getProgramDepth() {
		return Integer.valueOf(programDepth.getText());
	}
}
