package gui;


import mainClasses.ExecutionManager;
import mainClasses.ServerController;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


public class NewServerComposite extends Composite {
	
	private Text serverName = null;
	
	private Text serverPort = null;

	private ExecutionManager manager = null;
	
	public class AddButtonAdapter implements SelectionListener {

		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			if (manager != null) {
				ServerController controller = new ServerController();
				controller.setExecutionManager(manager);
				controller.setServername(serverName.getText());
				controller.setServerPort(Integer.valueOf(serverPort.getText()));
				manager.addServer(controller);
				controller.start();
			}
		}
		
	}

	public NewServerComposite(Composite parent, ExecutionManager manager, int style) {
		super(parent, style);
		
		this.manager = manager;
		
		this.setLayout(new GridLayout(1,false));
				
		Label labelServerName = new Label(this, SWT.NONE);
		labelServerName.setText("Server name:");
		labelServerName.setLayoutData(new GridData(SWT.HORIZONTAL));
		serverName = new Text(this, SWT.BORDER);
		serverName.setText("XXXXXXXXXXXXXXXXXXXXXXXXX");
		serverName.setLayoutData(new GridData(SWT.HORIZONTAL));
		
		Label labelPort = new Label(this, SWT.NONE);
		labelPort.setText("Port:");
		labelPort.setLayoutData(new GridData(SWT.HORIZONTAL));
		serverPort = new Text(this, SWT.BORDER);
		serverPort.setText("10001");
		serverPort.setLayoutData(new GridData(SWT.HORIZONTAL));
		
		Composite compositeButtonList = new Composite(this, SWT.NONE);
		compositeButtonList.setLayout(new RowLayout());
		
		Button addButton = new Button(compositeButtonList, SWT.BORDER);
		addButton.setText(" Add ");
		addButton.addSelectionListener(new AddButtonAdapter());

		compositeButtonList.pack();
		this.pack();
		serverName.setText("localhost");
	}
	
	public void setExecutionManager(ExecutionManager manager) {
		this.manager = manager;
	}
}
