package gui;


import mainClasses.GAPopulation;
import mainClasses.GAProgram;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;


public class PopulationComposite extends Composite {

	private Table table = null;
	
	private GAPopulation population = null;
	
	public PopulationComposite(Composite parent, int style) {
		super(parent, style);
		
		//Composite client = new Composite(parent, SWT.NONE);
		//client.setLayout(new FillLayout());
		this.setLayout(new FillLayout());
	
		//table = new Table(client, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION);
		table = new Table(this, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION);
		
		TableColumn columnIndex = new TableColumn(table, SWT.RIGHT);
		columnIndex.setText("Index");
		columnIndex.setWidth(40);
		TableColumn columnRating = new TableColumn(table, SWT.RIGHT);
		columnRating.setText("Rating");
		columnRating.setWidth(50);
		TableColumn columnProgram = new TableColumn(table, SWT.LEFT);
		columnProgram.setText("Program");
		columnProgram.setWidth(1000);

		table.addMouseListener(new ProgramTreeAdapter(table, parent.getShell()));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		//client.pack();
		this.pack();
	}

	public void setPopulation(GAPopulation newPopulation) {
		population = newPopulation;
	}
	
	public void update() {
		for (int i=0; i<population.getSize(); i++) {
			GAProgram program = population.get(i);
			TableItem tableItem = new TableItem(this.table, SWT.NONE);
			String [] stringArray = new String[] {String.valueOf(i), String.valueOf(program.getRating()), program.getProgramString()};
			tableItem.setData(program);
			tableItem.setText(stringArray);
		}
	}
}
