package gui;

import mainClasses.GAGenerationGenerator;
import mainClasses.GAPopulation;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class PopulationGenerateAdapter implements SelectionListener {

	private GAPopulation population = null;
	
	private GAGenerationGenerator generationGenerator = null;
	
	private NewComposite composite = null;
		
	public PopulationGenerateAdapter(GAPopulation newPopulation,
			GAGenerationGenerator newGenerationGenerator) {
		population = newPopulation;
		generationGenerator = newGenerationGenerator;
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {
		if (generationGenerator != null) {
			generationGenerator.getProgramGenerator().setMaxDepth(composite.getProgramDepth());
			generationGenerator.getProgramGenerator().setFill(false);
			generationGenerator.generate(population, composite.getPopulationSize());
		} else {
			System.out.println("PopulationGenerateAdapter.widgetSelected(): ERROR: " + this.getClass().getName() + 
					".widgetSelected(SelectionEvent): generationGenerator == null");
		}
	}

	public void setComposite(NewComposite newComposite) {
		composite = newComposite;
	}

	public void setGenerationGenerator(GAGenerationGenerator newGenerationGenerator) {
		generationGenerator = newGenerationGenerator;
	}

	public void setPopulation(GAPopulation newPopulation) {
		population = newPopulation;
	}
}
