package gui;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import mainClasses.GAProgram;
import mainClasses.GASaveGraphViz;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProgramTreeAdapter implements MouseListener {

	private Table table = null;
	
	private class CurrentImage {
		public Image image = null;
	}
	
	public ProgramTreeAdapter(Table table, Shell newShell) {
		this.table = table;
	}
	
	@Override
	public void mouseDoubleClick(MouseEvent me) {
		String imgType = "gif";
		int index = this.table.getSelectionIndex();
		if (index >= 0) {
			TableItem item = this.table.getItem(index);
			GAProgram program = (GAProgram) item.getData();
			GASaveGraphViz saver = new GASaveGraphViz();
			String srcFile = "";
			try {
				srcFile = URLDecoder.decode(getClass().getProtectionDomain().getCodeSource().getLocation().getPath(),"UTF-8");
			} catch (UnsupportedEncodingException e) {
			}
			String[] dirs = srcFile.split("/");
			srcFile = "";
			for (int i=0; i<dirs.length-1; i++) {
				srcFile = srcFile + dirs[i] + "/";
			}
			saver.save(srcFile + "program.dot", program);
			String dotProgramPath = srcFile + "graphviz/bin/dot.exe";
			File file = new File(dotProgramPath);
			if (file.exists()) {
				try {
					String cmd = dotProgramPath + " -T" + imgType + " " + 
									srcFile.substring(1) + "program.dot" + 
									" -o " + srcFile.substring(1) + "program." + imgType;
					Process p = Runtime.getRuntime().exec( cmd );
					p.waitFor();
				} catch (IOException e) {
				} catch (InterruptedException e) {
				}
			}
			final Shell newWindowShell = new Shell(Display.getCurrent(), SWT.SHELL_TRIM | SWT.NO_BACKGROUND | 
					SWT.NO_REDRAW_RESIZE | SWT.V_SCROLL | SWT.H_SCROLL);
			newWindowShell.setText("Program");
			file = new File(srcFile + "program." + imgType);
			if (file.exists()) {
				final Image orgImage = new Image(Display.getCurrent(), srcFile + "program." + imgType);
				//final Image image = orgImage;
				final CurrentImage currentImage = new CurrentImage();
				currentImage.image = orgImage;
				final Point origin = new Point(0,0);
				final ScrollBar hBar = newWindowShell.getHorizontalBar();
				hBar.addListener(SWT.Selection, new Listener() {
					public void handleEvent(Event e) {
						int hSelection = hBar.getSelection();
						int destX = -hSelection - origin.x;
						Rectangle rect = currentImage.image.getBounds();
						newWindowShell.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
						origin.x = -hSelection;
					}
				});
				final ScrollBar vBar = newWindowShell.getVerticalBar();
				vBar.addListener(SWT.Selection, new Listener() {
					public void handleEvent(Event e) {
						int vSelection = vBar.getSelection();
						int destY = -vSelection - origin.y;
						Rectangle rect = currentImage.image.getBounds();
						newWindowShell.scroll(0, destY, 0, 0, rect.width, rect.height, false);
						origin.y = -vSelection;
					}
				});
				newWindowShell.addListener(SWT.Resize, new Listener() {
					public void handleEvent(Event e) {
						Rectangle rect = currentImage.image.getBounds();
						Rectangle client = newWindowShell.getClientArea();
						hBar.setMaximum(rect.width);
						vBar.setMaximum(rect.height);
						hBar.setThumb(Math.min(rect.width, client.width));
						vBar.setThumb(Math.min(rect.height, client.height));
						int hPage = rect.width - client.width;
						int vPage = rect.height = client.height;
						int hSelection = hBar.getSelection();
						int vSelection = vBar.getSelection();
						if (hSelection >= hPage) {
							if (hPage <= 0) {
								hSelection = 0;
							}
							origin.x = -hSelection;
						}
						if (vSelection >= vPage) {
							if (vPage <= 0) {
								vSelection = 0;
							}
							origin.y = -vSelection;
						}
						newWindowShell.redraw();
					}
				});
				newWindowShell.addListener(SWT.Paint, new Listener() {
					public void handleEvent(Event e) {
						GC gc = e.gc;
						gc.drawImage(currentImage.image, origin.x, origin.y);
						Rectangle rect = currentImage.image.getBounds();
						Rectangle client = newWindowShell.getClientArea();
						int marginWidth = client.width - rect.width;
						if (marginWidth > 0) {
							gc.fillRectangle(rect.width, 0, marginWidth, client.height);
						}
						int marginHeight = client.height - rect.height;
						if (marginHeight > 0) {
							gc.fillRectangle(0, rect.height, client.width, marginHeight);
						}
					}
				});
				newWindowShell.addKeyListener(new KeyListener() {
					private int zoom = 100;
					@Override
					public void keyPressed(KeyEvent e) {
						int oldZoom = zoom;
						if (e.character == '+') {
							zoom = zoom + 10;
						}
						if (e.character == '-') {
							zoom = zoom - 10;
						}
						if (zoom < 10) {
							zoom = 10;
						}
						if (zoom > 200) {
							zoom = 200;
						}
						int width = (orgImage.getBounds().width / 100) * zoom;
						int height = (orgImage.getBounds().height / 100) * zoom;
						currentImage.image = new Image(Display.getCurrent(), width, height);
						GC gc = new GC(currentImage.image);
						gc.drawImage(orgImage, 0, 0, orgImage.getBounds().width, orgImage.getBounds().height, 0, 0, width, height);
						gc.dispose();
						hBar.setMaximum(width);
						vBar.setMaximum(height);
						Rectangle client = newWindowShell.getClientArea();
						hBar.setThumb(Math.min(width, client.width));
						vBar.setThumb(Math.min(height, client.height));
						int h = (hBar.getSelection() * 100 / oldZoom) / 100 * zoom;
						int v = (vBar.getSelection() * 100 / oldZoom) / 100 * zoom;
						hBar.setSelection(h);
						vBar.setSelection(v);
						newWindowShell.scroll(h, v, 0, 0, width, height, true);
						newWindowShell.redraw();
					}
					@Override
					public void keyReleased(KeyEvent e) {
					}
				});
			}
			newWindowShell.pack();
			newWindowShell.pack();
			newWindowShell.open();
		}
	}

	@Override
	public void mouseDown(MouseEvent e) {
	}

	@Override
	public void mouseUp(MouseEvent e) {
	}
}
