package gui;

import mainClasses.ServerController;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

public class ServerConsoleAdapter implements SelectionListener {

	private ServerController controller = null;
	
	private Shell shell = null;

	public ServerConsoleAdapter(ServerController controller, Shell newShell) {
		this.controller = controller;
		shell = newShell;
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {
		Shell newWindowShell = new Shell(shell);
		newWindowShell.setText("Server Console: " + controller.getServerName());
		/*NewComposite newComposite = */new ServerConsoleComposite(newWindowShell, controller, SWT.NONE);
		newWindowShell.pack();
		newWindowShell.open();
	}

	public void setServerController(ServerController controller) {
		this.controller = controller;
	}

}
