package gui;


import mainClasses.ServerController;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


public class ServerConsoleComposite extends Composite {

	private ServerController controller = null;
	
	private Label serverStatusLabel = null;
	
	private Text serverNameText = null;
	
	private class ShutdownAdapter implements SelectionListener {

		private ServerController controller = null;

		public ShutdownAdapter(ServerController controller) {
			this.controller = controller;
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			controller.sendShutdown();
		}
		
	}

	private class ServerStatusAdapter implements SelectionListener {

		private ServerController controller = null;
		
		private Label statusLabel = null;

		public ServerStatusAdapter(ServerController controller, Label label) {
			this.controller = controller;
			statusLabel = label;
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			String txt = controller.getServerStatus() + " \t\t ";
			switch (controller.getStatus()) {
			case DOWN: txt = txt + "[DOWN]"; break;
			case MANUAL: txt = txt + "[MANUAL]"; break;
			case AUTOMATIC: txt = txt + "[AUTOMATIC]"; break;
			}
			statusLabel.setText(txt);
		}
		
	}

	private class AutomaticStatusAdapter implements SelectionListener {

		private ServerController controller = null;
		
		public AutomaticStatusAdapter(ServerController controller) {
			this.controller = controller;
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			controller.activateAutomaticMode();
		}
		
	}

	private class ManualStatusAdapter implements SelectionListener {

		private ServerController controller = null;
		
		public ManualStatusAdapter(ServerController controller) {
			this.controller = controller;
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			controller.activateManualMode();
		}
		
	}

	private class StartOneStatusAdapter implements SelectionListener {

		private ServerController controller = null;
		
		public StartOneStatusAdapter(ServerController controller) {
			this.controller = controller;
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			controller.activateStartOneMode();
		}
		
	}

	private class SendSettingAdapter implements SelectionListener {

		private ServerController controller = null;
		
		public SendSettingAdapter(ServerController controller) {
			this.controller = controller;
		}
		
		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			controller.sendSetting(serverNameText.getText());
		}
		
	}

	public ServerConsoleComposite(Composite parent, ServerController controller, int style) {
		super(parent, style);
		
		this.controller = controller;
		this.setLayout(new GridLayout(1,false));
		
		Label labelLabelStatus = new Label(this, SWT.NONE);
		labelLabelStatus.setText("Server Status:");
		labelLabelStatus.setLayoutData(new GridData(SWT.HORIZONTAL));

		serverStatusLabel = new Label(this, SWT.NONE);
		serverStatusLabel.setText("UNKNOWN UNKNOWN UNKNOWN");
		serverStatusLabel.setLayoutData(new GridData(SWT.HORIZONTAL));
		
		Label labelGameServerName = new Label(this, SWT.NONE);
		labelGameServerName.setText("Game server name:");
		labelGameServerName.setLayoutData(new GridData(SWT.HORIZONTAL));
		serverNameText = new Text(this, SWT.BORDER);
		serverNameText.setText("localhost");
		serverNameText.setLayoutData(new GridData(SWT.HORIZONTAL));

		Composite compositeButtonList = new Composite(this, SWT.NONE);
		compositeButtonList.setLayout(new RowLayout());
		
		Button getStatusButton = new Button(compositeButtonList, SWT.BORDER);
		getStatusButton.setText(" Status ");
		getStatusButton.addSelectionListener(new ServerStatusAdapter(this.controller, serverStatusLabel));
		
		Button shutdownButton = new Button(compositeButtonList, SWT.BORDER);
		shutdownButton.setText(" Shutdown ");
		shutdownButton.addSelectionListener(new ShutdownAdapter(this.controller));
		
		Button automaticButton = new Button(compositeButtonList, SWT.BORDER);
		automaticButton.setText(" Automatic ");
		automaticButton.addSelectionListener(new AutomaticStatusAdapter(this.controller));
		
		Button manualButton = new Button(compositeButtonList, SWT.BORDER);
		manualButton.setText(" Manual ");
		manualButton.addSelectionListener(new ManualStatusAdapter(this.controller));

		Button startOneButton = new Button(compositeButtonList, SWT.BORDER);
		startOneButton.setText(" Start One ");
		startOneButton.addSelectionListener(new StartOneStatusAdapter(this.controller));
		
		Button settingButton = new Button(compositeButtonList, SWT.BORDER);
		settingButton.setText(" Send settings ");
		settingButton.addSelectionListener(new SendSettingAdapter(this.controller));

		compositeButtonList.pack();
		
		this.pack();
	}

}
