package gui;

import mainClasses.ExecutionManager;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Shell;

public class ServerListAdapter implements SelectionListener {

	private Shell parentShell = null;
	
	private ServerListComposite serverListComposite = null;
	
	private Shell newWindowShell = null;
	
	private ExecutionManager manager = null;
		
	public ServerListAdapter(ExecutionManager manager, Shell theParentShell) {
		parentShell = theParentShell;
		this.manager = manager;
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {
		newWindowShell = new Shell(parentShell);
		newWindowShell.setText("Serverlist");
		newWindowShell.setLayout(new FillLayout());
		serverListComposite = new ServerListComposite(parentShell, newWindowShell, SWT.NONE);
		serverListComposite.setExecutionManager(manager);
		serverListComposite.update();
		newWindowShell.open();
	}

	public void setExecutionManager(ExecutionManager manager) {
		this.manager = manager;
	}

}
