package gui;


import mainClasses.ExecutionManager;
import mainClasses.ServerController;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;


public class ServerListComposite extends Composite {

	private Table table = null;
	
	private ExecutionManager manager = null;
	
	public ServerListComposite(Shell mainShell, Composite parent, int style) {
		super(parent, style);
		
		this.setLayout(new FillLayout());
	
		table = new Table(this, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION);
		
		TableColumn columnIndex = new TableColumn(table, SWT.LEFT);
		columnIndex.setText("Computername");
		columnIndex.setWidth(100);
		TableColumn columnRating = new TableColumn(table, SWT.LEFT);
		columnRating.setText("Port");
		columnRating.setWidth(100);
		
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		table.addMouseListener(new ServerTableShowConsoleAdapter(table, mainShell));

		this.pack();
	}

	public void setExecutionManager(ExecutionManager manager) {
		this.manager = manager;
	}
	
	public void update() {
		for (int i=0; i<manager.getServerCount(); i++) {
			ServerController controller = manager.getServer(i);
			TableItem tableItem = new TableItem(this.table, SWT.NONE);
			String [] stringArray = new String[] {controller.getServerName(), String.valueOf(controller.getServerPort())};
			tableItem.setText(stringArray);
			tableItem.setData(controller);
		}
	}
}
