package gui;

import mainClasses.ServerController;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ServerTableShowConsoleAdapter implements MouseListener {

	private Table table = null;
	
	private Shell shell = null;

	public ServerTableShowConsoleAdapter(Table table, Shell newShell) {
		this.table = table;
		shell = newShell;
	}
	
	@Override
	public void mouseDoubleClick(MouseEvent e) {
		int index = this.table.getSelectionIndex();
		if (index >= 0) {
			TableItem item = this.table.getItem(index);
			ServerController controller = (ServerController) item.getData();
			Shell newWindowShell = new Shell(shell);
			newWindowShell.setText("Server Console: " + controller.getServerName());
			new ServerConsoleComposite(newWindowShell, controller, SWT.NONE);
			newWindowShell.pack();
			newWindowShell.open();
		}
	}

	@Override
	public void mouseDown(MouseEvent e) {
	}

	@Override
	public void mouseUp(MouseEvent e) {
	}
}
