package gui;

import mainClasses.GAPopulation;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Shell;

public class ShowPopulationAdapter implements SelectionListener {

	private Shell parentShell = null;
	
	private PopulationComposite populationComposite = null;
	
	private Shell newWindowShell = null;
	
	private GAPopulation population = null;
		
	public ShowPopulationAdapter(Shell theParentShell) {
		parentShell = theParentShell;
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {
		newWindowShell = new Shell(parentShell);
		newWindowShell.setText("Generation: " + (population.getGeneration() + 1));
		newWindowShell.setLayout(new FillLayout());
		populationComposite = new PopulationComposite(newWindowShell, SWT.NONE);
		populationComposite.setPopulation(population);
		populationComposite.update();
		//newWindowShell.pack();
		newWindowShell.open();
	}

	public void setPopulation(GAPopulation newPopulation) {
		population = newPopulation;
	}

}
