package gui;

import java.util.Comparator;

import mainClasses.GAPopulation;
import mainClasses.GAStatistic;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StatisticAdapter implements SelectionListener {

	private Shell parentShell = null;
		
	private Shell newWindowShell = null;
	
	private GAPopulation population = null;
		
	private class StatisticItem {
		public int start = 0;
		public int end = 0;
		public int count = 0;
		public int sum = 0;
	}

	public class StatisticItemComparator implements Comparator<StatisticItem> {

		@Override
		public int compare(StatisticItem arg0, StatisticItem arg1) {
			if (arg0.start < arg1.start) {
				return -1;
			} else if (arg0.start > arg1.start) {
				return 1;
			} else {
				return 0;
			}
		}
		
	}

	public StatisticAdapter(GAPopulation population, Shell theParentShell) {
		parentShell = theParentShell;
		this.population = population;
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {
		newWindowShell = new Shell(parentShell);
		newWindowShell.setText("Statistics");
		newWindowShell.setLayout(new FillLayout());
		
		Text text = new Text(newWindowShell, SWT.BORDER | SWT.MULTI | SWT.READ_ONLY | SWT.H_SCROLL | SWT.V_SCROLL);
		String txt = "";
		if (population != null) {
			GAStatistic stat = new GAStatistic(population);
			txt = txt + stat.getText("size\t\t\t", stat.getPopulationSize(), 
					" programs(s)", -1, "no population");
			txt = txt + stat.getText("generation\t\t", stat.getGeneration(), 
					". generation(s)", -1, "no population");
						
			txt = txt + stat.getText("max\t\t\t", stat.getMaxPoints(), 
					" point(s)", -1, "no program rated");
			txt = txt + "max single\t\t = " + stat.getVText(stat.getMaxRating(), " point(s)", -1, "no program rated") + 
					" [" + stat.getVText(stat.getMaxRating() * 3, " point(s)", -1, "no program rated") + "]\n";
			txt = txt + stat.getText("min\t\t\t\t", stat.getMinPoints(), 
					" point(s)", -1, "no program rated");
			txt = txt + stat.getText("average\t\t", (int)stat.getAveragePoints(), 
					" point(s)", -1, "no program rated");
			txt = txt + stat.getText("std. derivation\t", (int)stat.getStandardDeviation(), 
					" point(s)", -1, "too less programs rated");
			txt = txt + "percent done\t = " + stat.getVText((int)(stat.getPercentDone()*100), "%", -1, "population size 0") + 
					" (" + stat.getVText(stat.getRatedProgramCount(), "", -1, "no program rated") +
					"/" + stat.getVText(stat.getPopulationSize(), "", -1, "population size 0") + ")\n";
			txt = txt + stat.getText("started\t\t\t", stat.getCurrentStartedProgramCount(), 
					" program(s)", -1, "error");
			txt = txt + stat.getText("min depth\t\t", stat.getMinProgramDepth(), 
					"", -1, "error");
			txt = txt + stat.getText("max depth\t\t", stat.getMaxProgramDepth(), 
					"", -1, "error");
			txt = txt + "\n";
			
			txt = txt + stat.getText("median\t\t\t", stat.getMedian(), " point(s)", 
					-1, "no program rated");
			txt = txt + "\t\t\t\t = " + stat.getVText(stat.getMedian(-5),"; ",-1, "") + 
					stat.getVText(stat.getMedian(-4),"; ",-1, "") +
					stat.getVText(stat.getMedian(-3),"; ",-1, "") + 
					stat.getVText(stat.getMedian(-2),"; ",-1, "") +
					stat.getVText(stat.getMedian(-1),"",-1, "") + " | " + 
					stat.getVText(stat.getMedian(+1),"; ",-1, "") +
					stat.getVText(stat.getMedian(+2),"; ",-1, "") + 
					stat.getVText(stat.getMedian(+3),"; ",-1, "") +
					stat.getVText(stat.getMedian(+4),"; ",-1, "") + 
					stat.getVText(stat.getMedian(+5),"",-1, "") + "\n";
			
			txt = txt + "worst 25%\t\t <= " + stat.getVText(stat.getMedian((float)0.25)," point(s)",-1, "too less programs rated") + "\n"; 
			txt = txt + "best 25%\t\t >= " + stat.getVText(stat.getMedian((float)0.75)," point(s)",-1, "too less programs rated") + "\n"; 

			txt = txt + stat.getText("aver. t50%\t", stat.getAverage((float)0.5, (float)1.0), 
					" point(s)", -1, "too less programs rated");
			txt = txt + "\n";
			
			int lastEnd = 0;
			for (int i=0; i<stat.getPointRangeCount(); i++) {
				GAStatistic.PointRangeItem item = stat.getPointRangeItem(i);
				if (lastEnd+1 < item.start) {
					txt = txt + "--------------------\n";
				}
				String title = item.start + " - " + item.end;
				txt = txt + title + (title.length() < 8 ? "\t" : "") + 
						(title.length() < 10 ? "\t" : "") + "\t\t = " +
						item.count + " \t (" + (item.count * 100 / stat.getRatedProgramCount()) + "%)";
				txt = txt + "\t " + (int)((double)item.sum / stat.getSinglePointSum() * 100) + "%\n";
				lastEnd = item.end;
			}
		} else {
			txt = txt + "first load population";
		}
		text.setText(txt);
		//newWindowShell.pack();
		newWindowShell.open();
	}

	public void setPopulation(GAPopulation newPopulation) {
		population = newPopulation;
	}

}
