package mainClasses;

import global.CreateProgramTree;


public class GAGenerationGenerator {

	private GAProgramGenerator programGenerator = null;
	
	private CreateProgramTree creater = null;
		
	public GAGenerationGenerator() {
	}
	
	public void generate(GAPopulation gap, int populationSize) {
		generate(gap, programGenerator, populationSize);
	}
	
	public void generate(GAPopulation gap, GAProgramGenerator gapg, int populationSize) {
		if (gap == null) {
			System.out.println("GAGenerationGenerator.generate(): ERROR: " + this.getClass().getName() + 
					".generate(GAPopulation, GAProgramGenerator, int) gap == null");
			return;
		}
		if (gapg == null) { 
			System.out.println("GAGenerationGenerator.generate(): ERROR: " + this.getClass().getName() + 
					".generate(GAPopulation, GAProgramGenerator, int) gapg == null");
			return;
		}
		gap.clear();
		for (int i=0; i<populationSize; i++) {
			GAProgram program = new GAProgram();
			program.setCreateProgramTree(this.creater);
			gapg.generate(program);
			gap.addProgram(program);
		}
	}

	public void setProgramGenerator(GAProgramGenerator gapg) {
		programGenerator = gapg;
	}

	public GAProgramGenerator getProgramGenerator() {
		return programGenerator;
	}
	
	public void setCreateProgramTree(CreateProgramTree cpt) {
		this.creater = cpt;
	}
	
	public CreateProgramTree getCreateProgramTree() {
		return this.creater;
	}
}
