package mainClasses;

import java.util.ArrayList;
import java.util.List;

import commands.AICommand;

public class GALibrary {

	public class LibraryProgram {
		public int id;
		public GAProgram program;
	}
	
	private List<LibraryProgram> library = null;
	
	private String managerID = "";
	
	private int maxSize = 0;
	
	private int maxID = 0;
		
	public GALibrary() {
		library = new ArrayList<LibraryProgram>();
	}
	
	public void addProgram(int id, GAProgram program) {
		LibraryProgram lProgram = new LibraryProgram();
		lProgram.id = id;
		lProgram.program = program;
		this.library.add(lProgram);
	}
	
	public void addProgram(int id, AICommand root) {
		LibraryProgram lProgram = new LibraryProgram();
		lProgram.id = id;
		GAProgram program = new GAProgram();
		program.setProgram(root);
		lProgram.program = program;
		this.library.add(lProgram);
	}
	
	public int addProgram(AICommand root) {
		if (this.library.size() < maxSize) {
			maxID = maxID + 1;
			addProgram(maxID, root);
			return maxID;
		} else {
			return -1;
		}
	}
	
	public GAProgram getProgram(int id) {
		for (int i=0; i<this.library.size(); i++) {
			if (this.library.get(i).id == id) {
				return this.library.get(i).program; 
			}
		}
		return null;
	}

	public List<LibraryProgram> getList() {
		return this.library;
	}
	
	public void clear() {
		this.library.clear();
	}
	
	public String setManagerID(String ID) {
		this.managerID = ID;
		return this.managerID;
	}
	
	public String getManagerID() {
		return this.managerID;
	}
	
	public int setMaxID(int ID) {
		this.maxID = ID;
		return this.maxID;
	}
	
	public int getMaxID() {
		return this.maxID;
	}
	
	public int setMaxSize(int size) {
		this.maxSize = size;
		return this.maxSize;
	}
	
	public int getMaxSize() {
		return this.maxSize;
	}
}
