package mainClasses;

import global.CreateProgramTree;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import mainClasses.ExecutionManager.StartingDirection;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

import commands.IAICommand;

public class GALoad {

	private CreateProgramTree createProgramTree = null;
	
	public GALoad() {
	}
	
	public CreateProgramTree setCreateProgramTree(CreateProgramTree cpt) {
		this.createProgramTree = cpt;
		return this.createProgramTree;
	}

	public void load(String filename, ExecutionManager executionManager) {
		if ((executionManager == null) || (this.createProgramTree == null)) {
			return;
		}
				
		try {
			File file = new File(filename);
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(); 
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse( file );
			
			Element rootElement = document.getDocumentElement();
			if (rootElement.getNodeName().equals("population")) {
				load(rootElement, executionManager.getPopulation());
			} else {
				Node programNode = rootElement.getFirstChild();
				while (programNode != null) {
					if (programNode.getNodeName().equals("configuration")) {
						loadConfiguration((Element) programNode, executionManager);
					//} else if (programNode.getNodeName().equals("library")) {
					//	loadLibrary((Element) programNode, executionManager.getNextGenerationGenerator().getLibrary());
					} else if (programNode.getNodeName().equals("population")) {
						load((Element)programNode, executionManager.getPopulation());
					}
					programNode = programNode.getNextSibling();
				}
			}
		} catch (ParserConfigurationException e) {
		} catch (SAXException e) {
		} catch (IOException e) {
		}
	}
	
	private void loadLibrary(Element root, GALibrary library) {
		if ((createProgramTree == null) || (root == null)) {
			return;
		}		

		int maxSize = 0;
		int maxID = 0;
		try {
			String tmp = root.getAttribute("maxSize");
			maxSize = Integer.valueOf(tmp);
		} catch (Exception e) {
		}
		try {
			String tmp = root.getAttribute("maxID");
			maxID = Integer.valueOf(tmp);
		} catch (Exception e) {
		}
		library.clear();
		library.setMaxSize(maxSize);
		library.setMaxID(maxID);
		
		Node programNode = root.getFirstChild();
		while (programNode != null) {
			if (programNode.getNodeName().equals("program")) {
				GAProgram program = new GAProgram();
				program.setCreateProgramTree(this.createProgramTree);
				int id = 0;
				try {
					String strID = ((Element)programNode).getAttribute("id");
					id = Integer.valueOf(strID);
				} catch (Exception e) {
				}
				library.addProgram(id, program);
			}
		}
	}

	private void loadConfiguration(Element root, ExecutionManager manager) {
		Node programNode = root.getFirstChild();
		while (programNode != null) {
			if (programNode.getNodeName().equals("startingdirection")) {
				String code = programNode.getTextContent();
				code = code.trim();
				if (code.equals("BACKWARD")) {
					manager.setStartingDirection(StartingDirection.BACKWARD);
				} else {
					manager.setStartingDirection(StartingDirection.FORWARD);
				}
			} else if (programNode.getNodeName().equals("ratingcount")) {
				String code = programNode.getTextContent().trim();
				int ratingCount = Integer.valueOf(code);
				manager.getPopulation().setRatingCount(ratingCount);
			} else if (programNode.getNodeName().equals("maxrating")) {
				String code = programNode.getTextContent().trim();
				int maxRating = Integer.valueOf(code);
				manager.getPopulation().setMaxRating(maxRating);
			} else if (programNode.getNodeName().equals("maxprogramdepth")) {
				String code = programNode.getTextContent().trim();
				int maxDepth = Integer.valueOf(code);
				manager.getNextGenerationGenerator().setMaxProgramDepth(maxDepth);
			} else if (programNode.getNodeName().equals("mutationrate")) {
				String code = programNode.getTextContent().trim();
				double mutation = Double.valueOf(code);
				manager.getNextGenerationGenerator().setMutationRate(mutation);
			} else if (programNode.getNodeName().equals("acceptrate")) {
				String code = programNode.getTextContent().trim();
				double accept = Double.valueOf(code);
				manager.getNextGenerationGenerator().setAcceptRate(accept);
			} else if (programNode.getNodeName().equals("libraryrate")) {
				String code = programNode.getTextContent().trim();
				double rate = Double.valueOf(code);
				manager.getNextGenerationGenerator().setLibraryRate(rate);
			} else if (programNode.getNodeName().equals("maxlibrarydepth")) {
				String code = programNode.getTextContent().trim();
				int maxDepth = Integer.valueOf(code);
				manager.getNextGenerationGenerator().setMaxLibraryDepth(maxDepth);
			}
			programNode = programNode.getNextSibling();
		}		
	}
	
	private void load(Element root, GAPopulation population) {
		if ((createProgramTree == null) || (root == null)) {
			return;
		}		
			
		population.block();
		population.clear();

		String generation = "0";
		try {
			generation = root.getAttribute("generation");
			population.setGeneration(Integer.valueOf(generation));
		} catch (Exception e) {	
		}
		Node programNode = root.getFirstChild();
		while (programNode != null) {
			if (programNode.getNodeName().equals("program")) {
				GAProgram program = new GAProgram();
				program.setCreateProgramTree(this.createProgramTree);
				String rating = "0";
				try {
					rating = ((Element)programNode).getAttribute("rating");
					program.setRating(Integer.valueOf(rating));
				} catch (Exception e) {
				}
				Node codeNode = programNode.getFirstChild();
				while (codeNode != null) {
					if (codeNode.getNodeName().equals("subratings")) {
						Node ratingNode = codeNode.getFirstChild();
						while (ratingNode != null) {
							if (ratingNode.getNodeName().equals("rating")) {
								int rate = Integer.valueOf(ratingNode.getTextContent());
								program.addRating(rate);
							}
							ratingNode = ratingNode.getNextSibling();
						}
					} else if (codeNode.getNodeName().equals("code")) {
						String code = codeNode.getTextContent();
						code.replace("\n", "");
						code.replace("\r", "");
						code.replace("\t", "");
						code = code.trim();
						IAICommand rootCmd = createProgramTree.interpret(code);
						if (rootCmd != null) {
							program.setProgram(rootCmd);
						}
					}
					codeNode = codeNode.getNextSibling();
				}
				population.addProgram(program);
			}
			programNode = programNode.getNextSibling();
		}
		population.unblock();
	}
}
