package mainClasses;

import global.CreateProgramTree;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import commands.AICommand;

public class GANextGenerationGenerator {

	private Random random = null;
	
	private GAProgramGenerator programGenerator = null;
	
	private CreateProgramTree creater = null;
	
	private boolean newNodeSelectionMethod = false;
	
	private double acceptRate = 0.01;
	
	private double mutationRate = 0.001;
	
	private double libraryRate = 0.000;
	
	private int maxProgramDepth = 45;
	
	private int maxLibraryDepth = 10;
	
	private GALibrary library = null;
	
	public GANextGenerationGenerator(Random random, GAProgramGenerator cpt) {
		this.random = random;
		this.programGenerator = cpt;
	}
	
	public void createNextGeneration(GAPopulation population) {
		if (random == null) {
			return;
		}
		
		if (population == null) {
			return;
		}
		
		if (!(population.getSize() > 0)) {
			return;
		}
		
		List<GAProgram> next = new ArrayList<GAProgram>();
		int populationSize = population.getSize();
		
		int count = (int)(acceptRate * populationSize);

		for (int i=0; i<count; i++) {
			GAProgram program = new GAProgram();
			program.setCreateProgramTree(this.creater);
			AICommand root = (AICommand)(population.get(populationSize - i - 1).getProgram());
			program.setProgram(root.copy());
			program.setNotStarted();
			if (program != null) {
				next.add(program);
			}
		}

		// get sum of all ratings -> useful for rating depending selection
		int ratingSum = getRatingSum(population, populationSize);
				
		while (next.size()<populationSize) {			
			if (this.random.nextFloat() < this.mutationRate) {
				GAProgram program = doMutation(population, populationSize, ratingSum);
				if (program != null) {
					if (((AICommand)program.getProgram()).getProgramDepth() < maxProgramDepth) {
						next.add(program);
					}
				}
			} else {
				GAProgram program = doCrossOver(population, populationSize, ratingSum);
				if (program != null) {
					if (((AICommand)program.getProgram()).getProgramDepth() < maxProgramDepth) {
						next.add(program);
					}
				}
			}
		}
		
		// Library modification
		count = (int)(libraryRate * populationSize);
		for (int i=0; i<count; i++) {
			// TODO: Library modification is missing
			GAProgram ret = population.get(random.nextInt(populationSize));
			AICommand[] selNodeA = null;
			do {
				selNodeA = CrossOverSelectNode((AICommand)ret.getProgram(), false, -1, -1);
			} while (maxLibraryDepth > selNodeA[1].getProgramDepth()); 
		}
		
		// copy new program into population
		population.clear();
		population.addAllPrograms(next);
		population.setGeneration(population.getGeneration() + 1);
	}

	private GAProgram doCrossOver(GAPopulation population, int populationSize,
			int ratingSum) {
		// select programs
		GAProgram selectedA = selectRandomProgram(population, populationSize, ratingSum);
		GAProgram selectedB = selectRandomProgram(population, populationSize, ratingSum);
		// DEBUG
		System.out.println("GANextGenGenerator.doCrossOver: ProgA: " + selectedA.getRating());
		System.out.println("GANextGenGenerator.doCrossOver: ProgB: " + selectedB.getRating());
		System.out.println("GANextGenGenerator.doCrossOver: -------------------------------");
		//System.out.println("A: " + selectedA.getProgramString());
		//System.out.println("B: " + selectedB.getProgramString());
		// copy Program
		AICommand rootA = (AICommand)((AICommand)selectedA.getProgram()).copy();
		AICommand rootB = (AICommand)((AICommand)selectedB.getProgram()).copy();
		// select node
		AICommand[] selNodeA = CrossOverSelectNode(rootA, false, -1, -1);
		AICommand[] selNodeB = null;
		if (selNodeA[1] != null) {
			selNodeB = CrossOverSelectNode(rootB, true, -1, -1);
		}
		// cross over
		if (selNodeA[1] != null) {
			for (int i=0; i<selNodeA[0].getCurrentParameterCount(); i++) {
				if (selNodeA[0].getParameter(i) == selNodeA[1]) {
					selNodeA[0].setParameter(i, selNodeB[1]);
					break;
				}
			}
			//System.out.println("Erg: " + rootA.getString());
			GAProgram ret = new GAProgram();
			ret.setCreateProgramTree(this.creater);
			ret.setProgram(rootA);
			ret.setNotStarted();
			return ret;
		} else {
			return null;
		}
	}
	
	private GAProgram doMutation(GAPopulation population, int populationSize,
			int ratingSum) {
		if (this.programGenerator == null) {
			return null;
		}
		// select program
		GAProgram selectedA = selectRandomProgram(population, populationSize, ratingSum);
		// DEBUG
		System.out.println("GANextGenGenerator.doMutation : ProgA: " + selectedA.getRating());
		System.out.println("GANextGenGenerator.doCrossOver: -------------------------------");
		// copy Program
		AICommand rootA = (AICommand)((AICommand)selectedA.getProgram()).copy();
		// select node
		AICommand[] selNodeA = CrossOverSelectNode(rootA, false, -1, -1);
		// mutate
		if (selNodeA[1] != null) {
			for (int i=0; i<selNodeA[0].getCurrentParameterCount(); i++) {
				if (selNodeA[0].getParameter(i) == selNodeA[1]) {
					int depth = selNodeA[1].getProgramDepth() + random.nextInt(3) - 1;
					selNodeA[0].setParameter(i, (AICommand)programGenerator.generate(depth,false));
					break;
				}
			}
			GAProgram ret = new GAProgram();
			ret.setCreateProgramTree(this.creater);
			ret.setProgram(rootA);
			ret.setNotStarted();
			return ret;
		} else {
			return null;
		}
	}

	private AICommand[] CrossOverSelectNode(AICommand root, boolean rootPossible, int minDepth, int maxDepth) {
		AICommand[] selectNode = new AICommand[2];
		selectNode[0] = null; // Parent
		selectNode[1] = root; // Selected Node
		int depth = 0;
		while (true) {
			depth = depth + 1;
			if ((selectNode[0] == null) && (!rootPossible)) {
				if (selectNode[1].getCurrentParameterCount() > 0) {
					int select = random.nextInt(getParamRandomNumber(selectNode[1]));
					selectNode[0] = selectNode[1];
					selectNode[1] = getParamFromRandomNumber(selectNode[0], select);
				} else {
					selectNode[0] = selectNode[1];
					selectNode[1] = null;
					break;
				}
			} else {
				int select = random.nextInt(getParamRandomNumber(selectNode[1]) + depth);
				if (select < depth) {
					break;
				} else {
					selectNode[0] = selectNode[1];
					selectNode[1] = getParamFromRandomNumber(selectNode[0], select - depth);
				}
			}
		}
		return selectNode;
	}
	
	private int getParamRandomNumber(AICommand Node) {
		if (newNodeSelectionMethod) {
			return ((Node.getProgramDepth() - 1) * Node.getCurrentParameterCount());
		} else {
			int tmp = 0;
			for (int i = 0; i < Node.getCurrentParameterCount(); i++) {
				tmp = tmp + ((AICommand)Node.getParameter(i)).getProgramDepth();
			}
			return tmp;
		}
	}
	
	private AICommand getParamFromRandomNumber(AICommand Node, int number) {
		if (newNodeSelectionMethod) {
			AICommand ret = null;
			int max = Node.getProgramDepth() - 1;
			for (int i = 0; i < Node.getCurrentParameterCount(); i++) {
				number = number - max; 
				if (number < 0) {
					ret = ((AICommand)Node.getParameter(i));
					break;
				}
			}
			return ret;
		} else {
			AICommand ret = null;
			for (int i = 0; i < Node.getCurrentParameterCount(); i++) {
				number = number - ((AICommand)Node.getParameter(i)).getProgramDepth(); 
				if (number < 0) {
					ret = ((AICommand)Node.getParameter(i));
					break;
				}
			}
			return ret;
		}
	}

	private int getRatingSum(GAPopulation population, int populationSize) {
		int ratingSum = 0;
		for (int i=0; i<populationSize; i++) {
			ratingSum = ratingSum + population.get(i).getRating();
			//ratingSum = ratingSum + (population.get(i).getRating() * (population.get(i).getRating() / 2));
			//System.out.println("rS: " + ratingSum);
		}
		return ratingSum;
	}

	private GAProgram selectRandomProgram(GAPopulation population, int populationSize, int ratingSum) {
		GAProgram ret = null;
		int r = random.nextInt(ratingSum);
		for (int j=0; j<populationSize; j++) {
			r = r - population.get(j).getRating();
			//r = r - (population.get(j).getRating() * (population.get(j).getRating() / 2));
			if (r < 0) {
				//System.out.println("GANextGenGen.selectRandomProgram(): index: " + j);
				ret = population.get(j);
				break;
			}
		}
		return ret;
	}
	
	public void setCreateProgramTree(CreateProgramTree cpt) {
		this.creater = cpt;
	}
	
	public CreateProgramTree getCreateProgramTree() {
		return this.creater;
	}

	public GALibrary setLibrary(GALibrary library) {
		this.library = library;
		return this.library;
	}
	
	public GALibrary getLibrary() {
		return this.library;
	}
	
	public int setMaxProgramDepth(int depth) {
		this.maxProgramDepth = depth;
		return this.maxProgramDepth;
	}
	
	public int getMaxProgramDepth() {
		return this.maxProgramDepth;
	}
	
	public int setMaxLibraryDepth(int depth) {
		this.maxLibraryDepth = depth;
		return this.maxLibraryDepth;
	}
	
	public int getMaxLibraryDepth() {
		return this.maxLibraryDepth;
	}
	
	public double setMutationRate(double rate) {
		this.mutationRate = rate;
		return this.mutationRate;
	}
	
	public double getMutationRate() {
		return this.mutationRate;
	}
	
	public double setLibraryRate(double rate) {
		this.libraryRate = rate;
		return this.libraryRate;
	}
	
	public double getLibraryRate() {
		return this.libraryRate;
	}
	
	public double setAcceptRate(double rate) {
		this.acceptRate = rate;
		return this.acceptRate;
	}
	
	public double getAcceptRate() {
		return this.acceptRate;
	}
}
