package mainClasses;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class GAPopulation {

	private List<GAProgram> population = null;
	
	private int generation = 0;
	
	private boolean blocked = false;
	
	private int ratingCount = 5;
	
	private int maxRating = 5000;

	public GAPopulation() {
		population = new ArrayList<GAProgram>();
	}
	
	public void block() {
		blocked = true;
	}
	
	public void unblock() {
		blocked = false;
	}
	
	public void addProgram(GAProgram toAdd) {
		population.add(toAdd);
	}
	
	public void addAllPrograms(List<GAProgram> toAdd) {
		population.addAll(toAdd);
	}
	
	public void clear() {
		population.clear();
	}
	
	public int getSize() {
		return population.size();
	}
	
	public GAProgram get(int i) {
		if (!blocked) {
			return population.get(i);
		} else {
			return null;
		}
	}

	public int setGeneration(int newGeneration) {
		generation = newGeneration;
		return generation;
	}
	
	public int getGeneration() {
		return generation;
	}

	public class RatingComparator implements Comparator<GAProgram> {

		@Override
		public int compare(GAProgram arg0, GAProgram arg1) {
			if (arg0.getRating() < arg1.getRating()) {
				return -1;
			} else if (arg0.getRating() > arg1.getRating()) {
				return 1;
			} else {
				return 0;
			}
		}
		
	}

	public void sortPopulation() {
		Collections.sort(population,new RatingComparator());
	}

	public void setRating(String identifier, int rating) {
		Date d = new Date();
		DateFormat df = DateFormat.getTimeInstance( DateFormat.MEDIUM, Locale.GERMANY ); 
	
		for (int i=0; i<this.getSize(); i++) {
			GAProgram program = population.get(i);
			if ((program.getIdentifier().equals(identifier)) && 
					(program.getRating() < 0) && (program.isStarted() == true)) {
				program.setFinished();
				program.setRatingCount(this.ratingCount);
	
				this.maxRating = rating < (this.maxRating * 3) ? 
						(rating > this.maxRating ? rating : this.maxRating) : this.maxRating;
	
				program.setMaxRating(this.maxRating);
				program.addRating(rating);
				String txt = "GAPopulation.setRating(): " + i + ". " + rating + " points";
				if (program.getRating() > -1) {
					txt = txt + " => " + program.getRating() + " points";
				} else {
					txt = txt + " => rating not finished";
				}
				System.out.println(df.format(d) + " " + txt);
			}
		}
	}
	
	public int setRatingCount(int ratingCount) {
		this.ratingCount = ratingCount;
		return this.ratingCount;
	}
	
	public int getRatingCount() {
		return this.ratingCount;
	}
	
	public int setMaxRating(int maxRating) {
		this.maxRating = maxRating;
		return this.maxRating;
	}
	
	public int getMaxRating() {
		return this.maxRating;
	}
}
