package mainClasses;

import global.CreateProgramTree;

import java.util.ArrayList;
import java.util.List;

import commands.AICommand;
import commands.IAICommand;

public class GAProgram {

	private int rating = -1;

	private int ratingCount = 5;
	
	private List<Integer> ratings = null;
	
	private CreateProgramTree creater = null;
	
	private IAICommand program = null;
	
	private String programString = "";
	
	private boolean running = false;
	
	private String identifier = "";
	
	private long timeout = 0;
	
	private boolean blocked = false;
	
	public int maxRating = 5000;
	
	public GAProgram() {
		ratings = new ArrayList<Integer>();
	}
	
	public IAICommand setProgram(IAICommand root) {
		if (this.creater == null) {
			this.program = root;
			return this.program;
		} else {
			this.programString = ((AICommand)root).getString();
			return root;
		}
	}
	
	public IAICommand getProgram() {
		if ((!programString.isEmpty()) && (this.creater != null)) {
			return this.creater.interpret(programString);
		}
		return program;
	}
	
	public int setRating(int newRating) {
		maxRating = newRating > maxRating ? newRating : maxRating;
		rating = newRating;
		ratings = new ArrayList<Integer>();
		return rating;
	}
	
	public void addRating(int newRating) {
		if (newRating > (maxRating * 3)) {
			return;
		}

		if (ratings.size() < this.ratingCount) {
			ratings.add(new Integer(newRating));
		}
		if (ratings.size() >= this.ratingCount) {
			int sum = 0;
			int min = 200000000;
			int max = 0;
			for (int i=0; i<ratings.size(); i++) {
				sum = sum + ratings.get(i);
				if (min > ratings.get(i)) {
					min = ratings.get(i);
				}
				if (max < ratings.get(i)) {
					max = ratings.get(i);
				}
			}
			rating = (((sum - min - max) * 2) + min + max) / ((this.ratingCount - 2) * 2 + 2);
		}
	}
	
	public int getRating() {
		return rating;
	}
	
	public int getCurrentRatingCount() {
		return this.ratings.size();
	}
	
	public int getSubRating(int i) {
		if (i < this.ratings.size()) {
			return this.ratings.get(i);
		} else {
			return -1;
		}
	}
	
	public String getProgramString() {
		if (null != program) {
			return ((AICommand)program).getString();
		} else {
			return this.programString;
		}
	}

	public boolean isStarted() {
		return running;
	}

	public void setStarted() {
		running = true;
	}
	
	public void setFinished() {
		running = false;
	}
	
	public void setNotStarted() {
		running = false;
	}

	public String setIdentifier(String identifier) {
		this.identifier = identifier;
		return this.identifier;
	}
	
	public String getIdentifier() {
		return this.identifier;
	}
	
	public long setTimeout(long timeout) {
		this.timeout = timeout;
		return timeout;
	}
	
	public long getTimeout() {
		return timeout;
	}
	
	public void setCreateProgramTree(CreateProgramTree cpt) {
		this.creater = cpt;
	}
	
	public CreateProgramTree getCreateProgramTree() {
		return this.creater;
	}
	
	public boolean getBlockedStatus() {
		return this.blocked;
	}
	
	public boolean setBlockedStatus(boolean blocked) {
		this.blocked = blocked;
		return this.blocked;
	}
	
	public int setRatingCount(int ratingCount) {
		this.ratingCount = ratingCount;
		return this.ratingCount;
	}
	
	public int setMaxRating(int maxRating) {
		this.maxRating = maxRating;
		return this.maxRating;
	}
}
