package mainClasses;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import commands.AICommand;
import commands.IAICommand;

public class GAProgramGenerator {

	private List<IAICommand> commandList = null;
	
	private List<IAICommand> terminalCommands = null;
	
	private List<IAICommand> nodeCommands = null;
		
	private Random random = null;

	private int maxdepth = 0;
	
	private boolean fill = false;
	
	public GAProgramGenerator() {
		commandList = new ArrayList<IAICommand>();
	}

	public GAProgramGenerator(int newMaxDepth, boolean newFill) {
		commandList = new ArrayList<IAICommand>();
		maxdepth = newMaxDepth;
		fill = newFill;
	}
	
	public void addCommand(IAICommand command) {
		if (command != null) {
			commandList.add(command);
		}
	}
	
	public void addCommands(List<IAICommand> list) {
		for (int i=0; i<list.size(); i++) {
			commandList.add(list.get(i));
		}
	}

	public void clearCommandList() {
		commandList.clear();
	}
	
	public Random setRandom(Random newRandom) {
		random = newRandom;
		return random;
	}

	public int setMaxDepth(int newMaxDepth) {
		maxdepth = newMaxDepth;
		return maxdepth;
	}
	
	public boolean setFill(boolean newFill) {
		fill = newFill;
		return fill;
	}
	
	public void generate(GAProgram program) {
		generate(program, maxdepth, fill);
	}
	
	public void generate(GAProgram program, int maxdepth, boolean fill) {
		if (null == random) {
			random = new Random();
		}
		if (program != null) {
			if (commandList != null) {
				if (commandList.size() > 0) {
					createTerminalCommandList();
					createNodeCommandList();
					program.setProgram(createRoot(random, maxdepth, fill));
					program.setRating(-1);
				}
			}
		}
	}
	
	public IAICommand generate(int maxdepth, boolean fill) {
		if (null == random) {
			random = new Random();
		}
		createTerminalCommandList();
		createNodeCommandList();
		return createRoot(random, maxdepth, fill);
	}
	
	private void createTerminalCommandList() {
		terminalCommands = new ArrayList<IAICommand>();
		for (int i=0; i<commandList.size(); i++) {
			if (((AICommand)(commandList.get(i))).getParameterCount() == 0) {
				terminalCommands.add(commandList.get(i));
			}
		}
	}
	
	private void createNodeCommandList() {
		nodeCommands = new ArrayList<IAICommand>();
		for (int i=0; i<commandList.size(); i++) {
			if (((AICommand)(commandList.get(i))).getParameterCount() > 0) {
				nodeCommands.add(commandList.get(i));
			}
		}
	}
	
	private IAICommand createRoot(Random r, int missingDepth, boolean fill) {
		IAICommand ret = null;
		if (missingDepth == 0) {
			int pos = r.nextInt(terminalCommands.size());
			ret = ((AICommand)(terminalCommands.get(pos))).copyRandom();
		} else {
			if (fill == true) {
				int pos = r.nextInt(nodeCommands.size());
				ret = ((AICommand)(nodeCommands.get(pos))).copyRandom();
			} else {
				int pos = r.nextInt(commandList.size());
				ret = ((AICommand)(commandList.get(pos))).copyRandom();
			}
		}
		
		((AICommand)ret).setRandomValue(r);
		
		for (int i=0; i<((AICommand)ret).getParameterCount(); i++) {
			((AICommand)ret).addParameter(createRoot(r, missingDepth-1, fill));
		}
		return ret;
	}
}
