package mainClasses;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import mainClasses.GALibrary.LibraryProgram;

public class GASave {

	public GASave() {
	}
	
	public void save(String filename, ExecutionManager executionManager) {
		File file = new File(filename);
		try {
			FileOutputStream out = new FileOutputStream(file);
			out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n".getBytes());
			out.write(("<ga>\r\n").getBytes());
			out.write(("  <configuration>\r\n").getBytes());
			out.write(("    <startingdirection>").getBytes());
			switch (executionManager.getStartingDirection()) {
			case FORWARD: out.write(("FORWARD").getBytes()); break;
			case BACKWARD: out.write(("BACKWARD").getBytes()); break;
			}
			out.write(("</startingdirection>\r\n").getBytes());
			out.write(("    <ratingcount>" + executionManager.getPopulation().getRatingCount()).getBytes());
			out.write(("</ratingcount>\r\n").getBytes());
			out.write(("    <maxrating>" + executionManager.getPopulation().getMaxRating()).getBytes());
			out.write(("</maxrating>\r\n").getBytes());
			out.write(("    <maxprogramdepth>" + executionManager.getNextGenerationGenerator().getMaxProgramDepth()).getBytes());
			out.write(("</maxprogramdepth>\r\n").getBytes());
			out.write(("    <mutationrate>" + executionManager.getNextGenerationGenerator().getMutationRate()).getBytes());
			out.write(("</mutationrate>\r\n").getBytes());
			out.write(("    <acceptrate>" + executionManager.getNextGenerationGenerator().getAcceptRate()).getBytes());
			out.write(("</acceptrate>\r\n").getBytes());
			out.write(("    <libraryrate>" + executionManager.getNextGenerationGenerator().getLibraryRate()).getBytes());
			out.write(("</libraryrate>\r\n").getBytes());
			out.write(("    <maxlibrarydepth>" + executionManager.getNextGenerationGenerator().getMaxLibraryDepth()).getBytes());
			out.write(("</maxlibrarydepth>\r\n").getBytes());
			out.write(("  </configuration>\r\n").getBytes());
			save(out, executionManager.getNextGenerationGenerator().getLibrary());
			save(out, executionManager.getPopulation());
			out.write(("</ga>\r\n").getBytes());
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
	}
	
	private void save(FileOutputStream out, GALibrary library) throws IOException {
		out.write(("  <library maxSize=\"" + library.getMaxSize() + "\" maxID=\"" + library.getMaxID() + "\">\r\n").getBytes());
		List<LibraryProgram> list = library.getList();
		for (int i=0; i<list.size(); i++) {
			LibraryProgram l = list.get(i);
			out.write(("    <program id=\"" + l.id + "\">").getBytes());
			out.write((l.program.getProgramString() + "</program>\r\n").getBytes());
		}
		out.write(("  </library>\r\n").getBytes());
	}
	
	private void save(FileOutputStream out, GAPopulation population) throws IOException {
		out.write(("  <population generation=\"" + population.getGeneration() + "\">\r\n").getBytes());
		for (int i=0; i<population.getSize(); i++) {
			GAProgram program = population.get(i);
			out.write(("    <program rating=\"" + program.getRating() + "\">\r\n").getBytes());
			out.write(("      <subratings>\r\n").getBytes());
			for (int j=0; j<program.getCurrentRatingCount(); j++) {
				out.write(("        <rating>" + program.getSubRating(j)).getBytes());
				out.write(("</rating>\r\n").getBytes());
			}
			out.write(("      </subratings>\r\n").getBytes());
			out.write("      <code>\r\n".getBytes());
			out.write(("        " + program.getProgramString()).getBytes());
			out.write("\r\n      </code>\r\n".getBytes());
			out.write("    </program>\r\n".getBytes());
		}
		out.write("  </population>\r\n".getBytes());
	}
}
