package mainClasses;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import commands.AICommand;
import commands.AICommand.IsExecutedType;

public class GASaveGraphViz {

	public GASaveGraphViz() {
	}
	
	public void save(String filename, GAProgram program) {
		File file = new File(filename);
		try {
			FileOutputStream out = new FileOutputStream(file);
			out.write("digraph cmd {\r\n".getBytes());
			saveCmd(out, (AICommand) program.getProgram(), 0, IsExecutedType.ALWAYS);
			out.write("}\n".getBytes());
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
	}
	
	private int saveCmd(FileOutputStream out, AICommand cmd, int ID, IsExecutedType isExecuted) throws IOException {
		int OrgID = ID;
		boolean shortenNotExecuted = (IsExecutedType.NEVER == isExecuted);
		boolean shortenIsRealConstant = (cmd.isConstant() && !cmd.hasSideEffects(true) && (cmd.getProgramDepth() > 1));
		out.write(("  cmd_" + OrgID + " [").getBytes());
		String labelNode = "label=\"" + cmd.getShortName();
		if (shortenNotExecuted || shortenIsRealConstant) {
			labelNode = labelNode + "\\n" + cmd.getProgramDepth();
		}
		labelNode = labelNode + "\"";
		out.write(labelNode.getBytes());
		if (shortenNotExecuted) {
			out.write((",shape=box").getBytes());
		} else if (shortenIsRealConstant) {
			out.write((",shape=hexagon").getBytes());
		}
		out.write((")];\r\n").getBytes());
		if (!(shortenNotExecuted || shortenIsRealConstant)) {
			for (int i=0; i<cmd.getCurrentParameterCount(); i++) {
				out.write(("  cmd_" + OrgID + " -> cmd_" + (ID + 1)).getBytes());
				String edge = "";
				if (((AICommand)cmd.getParameter(i)).isConstant()) {
					edge = edge + "label=\"" + cmd.getParameter(i).doCommand(false) + "\"";
				}
				switch (cmd.isParameterExecuted(i)) {
				case MAYBE: break;
				case ALWAYS: 
					edge = edge + (edge.isEmpty() ? "" : ",") + "style=bold"; break;
				case NEVER: 
					edge = edge + (edge.isEmpty() ? "" : ",") + "style=dotted"; break;
				}
				if (!edge.isEmpty()) {
					out.write((" [" + edge + "]").getBytes());
				}
				out.write((";\r\n").getBytes());
				ID = saveCmd(out, (AICommand)cmd.getParameter(i), ID + 1, cmd.isParameterExecuted(i));
			}
		}
		return ID + 1;
	}
}
